""" wxpypg, A universal record browser for mac,linux and windows

    LICENSE
    =======

    Copyright (c) 2008, Bram Van Steenlandt
    All rights reserved.

    Redistribution and use in source and binary forms, with or without 
    modification, are permitted provided that the following conditions are met:

        * Redistributions of source code must retain the above copyright 
          notice, this list of conditions and the following disclaimer.
        * Redistributions in binary form must reproduce the above copyright 
          notice, this list of conditions and the following disclaimer in the 
          documentation and/or other materials provided with the distribution.
        * Neither the name of the <ORGANIZATION> nor the names of its 
          contributors may be used to endorse or promote products derived from 
          this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
    POSSIBILITY OF SUCH DAMAGE.

    NOTES
    =======
    This is alpha software.  Don't use it on valuable data.
    Parts of this software are based on Randall Smith his pure python postgresql software

"""
# templates
# this modules helps in loading xml files for
# the alteration of the layout and the print layout
# xml's can be created in any app and then we "import" them allowing the user to have it's own layout
# a future thing might be that we have our own xml builder for this
# xml are stored in the prefs folder under templates and then the name + type products_view.xml products_print.xml
import xml.dom.minidom
def getText(nodelist):
    rc = ""
    for node in nodelist:
        if node.nodeType == node.TEXT_NODE:
            rc = rc + node.data
    return rc     

        
class xmltemplate:
    def __init__(self,path):
        f = file(path)
        data = f.read()
        dom = xml.dom.minidom.parseString(data)
        self.xmlitems = []
        for types in ("sort","start","button","field","label","logo","dportal","portal","line","text","rect","stat","export","back","list","portalsizer","options"):
            fields = dom.getElementsByTagName(types)
            for field in fields:
                name = field.getElementsByTagName("name")[0]
                self.xmlitems.append(xmlitem("%s_%s"%(types,getText(name.childNodes))))
                self.xmlitems[len(self.xmlitems)-1].addprop("xmlname",getText(name.childNodes))
                for iden in ("flen","refind","command","arguments","labelw","posx","posy","filename","span","evt_update","sql","choices_sql","colwidths","find","readonly","otext","width","height","hide","fields","add","addsql","taborder","bold","size","evt_new","center","x2","y2","sum","title","bg_color","color","table","parent_field","link_field","where","primary","choices","items","condition","limit","version","disabled","position_output","overlaysql","resize","aftermove","sdir"):
                    name = field.getElementsByTagName(iden)
                    if len(name)>0:
                        name=name[0]
                        self.xmlitems[len(self.xmlitems)-1].addprop(iden,getText(name.childNodes))
    def hasitem(self,name):
        has=False
        for item in self.xmlitems:
            if item.getname()==name:has=True
        return has
    def item(self,name):
        has=None
        for item in self.xmlitems:
            if item.getname()==name:has=item
        return has
    def searchitems(self,name):
        dic = {}
        for x in self.xmlitems:
            if x.getprop(name):
                dic[x.getxmlname()]=x.getprop(name)
        return dic
class xmlitem:
    def __init__(self,name):
        self.props ={"name":name}
    def getname(self):
        return self.props["name"]
    def getxmlname(self):
        return self.props["xmlname"]
    def addprop(self,name,value):
        self.props[name]=value
    def getprop(self,name):
        if self.props.has_key(name):
            return self.props[name]
        else:
            return None
    def posx(self):
        if self.getprop("posx")==None:
            return None
        else:
            return float(self.getprop("posx"))
    def posy(self):
        if self.getprop("posy")==None:
            return None
        else:
            return float(self.getprop("posy"))
    def get_f_evt_update(self):
        if self.props.has_key("evt_update"):
            return self.props["evt_update"]
        else:
            return None
    def spanx(self):
        if self.props.has_key("spanx"):
            return int(self.props["spanx"])
        else:
            return 1
    def spany(self):
        if self.props.has_key("spany"):
            return int(self.props["spany"])
        else:
            return 1
        
