# generic helpers
""" wxpypg, A universal record browser for mac,linux and windows

    LICENSE
    =======

    Copyright (c) 2008, Bram Van Steenlandt
    All rights reserved.

    Redistribution and use in source and binary forms, with or without 
    modification, are permitted provided that the following conditions are met:

        * Redistributions of source code must retain the above copyright 
          notice, this list of conditions and the following disclaimer.
        * Redistributions in binary form must reproduce the above copyright 
          notice, this list of conditions and the following disclaimer in the 
          documentation and/or other materials provided with the distribution.
        * Neither the name of the <ORGANIZATION> nor the names of its 
          contributors may be used to endorse or promote products derived from 
          this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
    POSSIBILITY OF SUCH DAMAGE.

    NOTES
    =======
    This is alpha software.  Don't use it on valuable data.
    Parts of this software are based on Randall Smith his pure python postgresql software

"""
import wx
from wx import xrc
import  wx.lib.mixins.listctrl  as  listmix
import  wx.grid as  gridlib
import string
import threading
import time
import StringIO
import os,sys
import templates
import copy
from user import home
try:
    from reportlab.pdfgen import canvas
    #import reportlab
    import reportlab.lib.colors
    import reportlab.lib.pagesizes
    PDF=True
except:
    reportlab=None
    PDF = False

KNOWN_TYPES = ('int4','int','int8','text','varchar','char','numeric','float','date','time','numeric','bool','timestamptz')
filetypes = {}
filetypes[".jpg"]=["JFIF"]
filetypes[".pdf"]=["PDF"]
filetypes[".html"]=["html","HTML"]
filetypes[".gif"]=["GIF89"]
filetypes[".png"]=["PNG"]
filetypes[".ods"]=["vnd.oasis.opendocument.spreadsheet"]

def get_ext_fromdata(data):
    for fk in filetypes.keys():
        for posibs in filetypes[fk]:
            if string.find(data,posibs)>-1:
                return fk
    print "No matching extension was found:%s"%data[:50]
    return None
    

def sxml(xml,xml_name,alt_val):
    if xml:
        if xml.getprop(xml_name):
            return xml.getprop(xml_name)
        else:
            return alt_val
    else:
        return alt_val
def setuplang():
    basepath = os.getcwd()
    localedir = os.path.join(basepath,"locale")
    domain = "messages"
    langid = wx.LANGUAGE_DEFAULT
    global mylocale
    mylocale = wx.Locale(langid)
    mylocale.AddCatalogLookupPathPrefix(localedir)
    mylocale.AddCatalog(domain)
    print mylocale.GetCanonicalName()
    print mylocale.GetLocale()
    print mylocale.IsOk()
_ = wx.GetTranslation
def S(text):
    # could be unicode
    newtext = ""
    #e = wx.EncodingConverter()
    #e.Init(wx.FONTENCODING_UTF8,wx.FONTENCODING_ISO8859_1,wx.CONVERT_SUBSTITUTE)
    for t in text:
        if ord(t)>127 or ord(t)==92:
            newtext+="\%s"%hex(ord(t))[1:]
        else:
            newtext+=str(t) #unicode.encode(t,'iso-8859-15')
    return string.replace(str(newtext),"'","\\'")
class freecheckbox(wx.CheckBox):
    dbparent=None

class freetextctrl(wx.TextCtrl):
    dbparent = None
class freechoice(wx.Choice):
    dbparent=None
class freecombobox(wx.ComboBox):
    dbparent=None
    def SetMaxLength(self,len):
	pass
class freestatictext(wx.StaticText):
    sql=None
    def update(self):
        if self.sql:
            cursor = self.dbparent.db.cursor()
            s = self.dbparent.fhelp(self.sql)
            if s==None:
                self.SetLabel("")
                return
            cursor.execute(s)
            if cursor.error:
		self.dbparent.db.rollback()
                wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
                return
            data = cursor.fetchall()
            if len(data)==1:
                self.SetLabel(str(data[0][0]))
class fieldwithlabel:
    def __init__(self,parent,label,type,ro=False,width=None,height=None,maxlen=None,nolabel=False,list=False,xml=None):
        if nolabel==False:self.label = wx.StaticText(parent,wx.NewId(),label)
        self.nolabel=nolabel
        self.textlabel=label
        style=None
        self.name=label
        self.span=1
        self.maxlen=maxlen
        self.type=type
	self.parent=parent
        self.xml=xml
	self.reloader=False
        if not width:width = self.GetWidth()
        if not height:height=self.GetHeight()
        self.combo=False
        if self.xml:
            if self.xml.getprop("choices_sql"):
                cursor = parent.db.cursor()
                cursor.execute(self.xml.getprop("choices_sql"))
                data = cursor.fetchall()
                list=[]
                self.combo=True
		self.reloader=True
		self.reloadsql = self.xml.getprop("choices_sql")
                for d in data:
                    list.append(str(d[0]))
            if self.xml.getprop("readonly")=="True":ro=True
            width = int(sxml(self.xml,"width",width))
        self.list=list
        self.ro=ro
        if ro:
            style=wx.TE_READONLY
        if type=="text" and height>30:
            style=wx.TE_MULTILINE
            self.span=3
        if type=="bool":
            self.field = freecheckbox(parent,wx.NewId(),"True")
            self.field.dbparent=self
        elif list<>False and self.combo:
            self.field = freecombobox(parent,wx.NewId(),choices=list)
            self.field.dbparent=self
        elif list<>False:
            self.field = freechoice(parent,wx.NewId(),choices=list)
            self.field.dbparent=self
        elif style:
            self.field = freetextctrl(parent,wx.NewId(),style=style,size=(width,height))
	    self.field.Bind(wx.EVT_KEY_DOWN,self.OnKey)
            self.field.dbparent=self
        else:
            self.field = freetextctrl(parent,wx.NewId(),size=(width,height))
	    self.field.Bind(wx.EVT_KEY_DOWN,self.OnKey)
            self.field.dbparent=self
        if ro:
            self.field.SetBackgroundColour("#EEEEEE")
        if self.type in ("varchar","char") and not list:
            self.realmaxlen=self.maxlen-4
            self.field.SetMaxLength(self.realmaxlen)
            self.field.Bind(wx.EVT_TEXT_MAXLEN,self.maxlenerror)
	if self.xml:
	    if self.xml.getprop("bg_color"):self.field.SetBackgroundColour(str(self.xml.getprop("bg_color")))
	    if self.xml.getprop("color"):self.field.SetForegroundColour(str(self.xml.getprop("color")))
    def OnKey(self,event):
	if event.ControlDown():
	    key = event.GetKeyCode()
	    if key==84:
		# suppose to be today past combination
		cursor = self.parent.db.cursor()
		cursor.execute("select date(now());")
		data = cursor.fetchall()[0][0]
		self.SetVal(data)
	    else:
		event.Skip()
	else:
	    event.Skip()
    def SetCombo(self,function):
	self.function = function
	self.field.Bind(wx.EVT_COMBOBOX,self.function)
    def reload(self):
	# Only for sql combo boxes, not really a reload but wx seems to have problems with lots of delete/reloads
	if self.reloader:
	    #self.field.Unbind(wx.EVT_COMBOBOX)
	    cursor = self.parent.db.cursor()
	    print self.reloadsql
	    cursor.execute(self.reloadsql)
	    if cursor.error:
		self.parent.db.rollback()
                wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
	    data = cursor.fetchall()
	    if 1==0:self.field = wx.ComboBox()
	    inthere = self.field.GetItems()
	    newlist = []
	    for d in data:newlist.append(d[0])
	    for item in inthere:
		if item in newlist:
		    newlist.remove(item)
	    for new in newlist:
		self.field.Insert(str(new),self.field.GetCount())
	    #self.field.Bind(wx.EVT_COMBOBOX,self.function)
    def SetFocus(self):
        self.field.SetFocus()
    def GetFocus(self):
	self.field
    def f_update(self):
        if self.xml:
            return self.xml.get_f_evt_update()
        else:
            return None
    def maxlenerror(self,event):
        wx.MessageBox(_("This field can only contain %s letters.")%self.realmaxlen)
    def GetWidth(self):
        if self.type in ("int8","numeric","date"):
            return 100
	elif self.type in ("timestamptz"):
	    return 180
        elif self.type in ("int4"):
            return 70
        elif self.type in ("varchar"):
            return min(max(int((self.maxlen-4)*10)-2,64),256)
        elif self.type in ("text"):
            if self.maxlen<>None and self.maxlen<>-1:
                return min(max(int(self.maxlen*10)-2,64),256)
            else:
                return 256
        else:
            return 80
    def GetHeight(self):
        if self.type in ("text"):
            return 80
        else:
            if wx.Platform != "__WXMAC__":
                return 26
            else:
                return 22
    def GetDbValue(self):
        if self.type=="enum":
            val = self.field.GetStringSelection()
        elif self.type=='bool':
            if self.field.GetValue():
                return 't'
            else:
                return 'f'
	elif self.type in ("numeric","float"):
	    val = self.field.GetValue().replace(",",".")
        else:
            val = self.field.GetValue()
        if val=="":
            return None
        else:
            return val
    def SetVal(self,value):
        if self.type=="bool":
            if value in ('t','T','true','True',True):
                self.field.SetValue(True)
            else:
                self.field.SetValue(False)
        elif self.type=='enum':
            if value==None:
                self.field.SetStringSelection("")
            else:
                self.field.SetStringSelection(value)
        else:
            if value==None:
                self.field.SetValue("")
            else:
                self.field.SetValue(value)
    def find_mode(self,bool=True):
        self.SetVal(None)
        if self.ro:
            if self.type<>"bool":
                if bool:
                    self.field.SetEditable(True)
                    self.field.SetBackgroundColour("#FFFFFF")
                else:
                    self.field.SetEditable(False)
                    self.field.SetBackgroundColour("#EEEEEE")
        if self.type in ("varchar","char") and not self.list:
            if bool:
                self.field.SetMaxLength((self.realmaxlen*2)+6)
            else:
                self.field.SetMaxLength(self.realmaxlen)
        

class freebitmapbutton(wx.BitmapButton):
    pass
class artbitmap(wx.Bitmap):
    def __init__(self,name):
        path =os.getcwd()
        uri = path + str(os.sep) + "art" + str(os.sep) + name
        wx.Bitmap.__init__(self,uri)
class navwin:
    """This class is a spaceholder, it contains the functions fnames for the db, subclass the window from this"""
    def OnNavHover(self,event):
        print "Onhover function not implemented"
        event.Skip()
    def OnNavNoHover(self,event):
        print "OnNohover function not implemented"
        event.Skip()
    def OnNavNew(self,event):
        print "New record function not implemented"
        event.Skip()
    def OnNavSort(self,event):
        print "Sort function not implemented"
        event.Skip()
    def OnNavIfind(self,event):
        print "Ifind not implemented"
        event.Skip()
    def OnNavFind(self,event):
        print "Find not implemented"
        event.Skip()
    def OnNavFirst(self,event):
        print "Goto First not implemented"
        event.Skip()
    def OnNavPrev(self,event):
        print "Goto previous not implemented"
        event.Skip()
    def OnNavNext(self,event):
        print "Goto next not implemented"
        event.Skip()
    def OnNavLast(self,event):
        print "Goto last not implemented"
        event.Skip()
    def OnNavOmmit(self,event):
        print "Ommit not implemented"
        event.Skip()
    def OnNavExport(self,event):
        print "Export not implemented"
        event.Skip()
    def OnNavImport(self,event):
        print "Import not implemented"
        event.Skip()
    def OnNavDelete(self,event):
        print "delete not implemented"
        event.Skip()
    def OnNavPrint(self,event):
        print "Print not implemented"
        event.Skip()
    def OnNavOmmit(self,event):
        print "Ommit not implemented"
        event.Skip()
    def OnNavOpen(self,event):
        print "Open not implemented"
        event.Skip()       
    def OnNavSlider(self,event):
	print "Slider not implemented"
	event.Skip()
class navigationbar:
    """This bar is the standard navigation bar for the database"""
    def __init__(self,window,disabled=[]):
        self.window=window
        self.sizer = wx.BoxSizer(wx.HORIZONTAL)
        # buttonstyle
        if wx.Platform != "__WXGTK__":
            buttonstyle=wx.DEFAULT
        else:
            buttonstyle=wx.NO_BORDER
        # new,create new record
	self.disabled=disabled
        self.img_new = artbitmap("navnew.png")
        self.btn_new = freebitmapbutton(self.window,wx.NewId(),self.img_new,style=buttonstyle)
        self.sizer.Add(self.btn_new)
        self.btn_new.help=_("Create a new record [n]")
	self.btn_new.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
	self.btn_new.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
	self.btn_new.Bind(wx.EVT_BUTTON,self.window.OnNavNew)
        # save record, becomes sort, saving is automatic
        self.img_sort = artbitmap("navsort.png")
        self.btn_sort = freebitmapbutton(self.window,wx.NewId(),self.img_sort,style=buttonstyle)
        self.sizer.Add(self.btn_sort)
        self.btn_sort.help=_("Sort records... [s]")
        self.btn_sort.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_sort.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_sort.Bind(wx.EVT_BUTTON,self.window.OnNavSort)
        # find record interactive
        self.img_ifind = artbitmap("navifind.png")
        self.btn_ifind = freebitmapbutton(self.window,wx.NewId(),self.img_ifind,style=buttonstyle)
        self.sizer.Add(self.btn_ifind)
        self.btn_ifind.help=_("Find a record interactive [f]")
        self.btn_ifind.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_ifind.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_ifind.Bind(wx.EVT_BUTTON,self.window.OnNavIfind)
        # find record with find mode
        self.img_find = artbitmap("navfind.png")
        self.btn_find = freebitmapbutton(self.window,wx.NewId(),self.img_find,style=buttonstyle)
        self.sizer.Add(self.btn_find)
        self.btn_find.help=_("Find a record")
        self.btn_find.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_find.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_find.Bind(wx.EVT_BUTTON,self.window.OnNavFind)
	if wx.Platform != "__WXGTK__":
	    # first record -- first and last will be replaced with a slider
	    self.img_first = artbitmap("navfirst.png")
	    self.btn_first = freebitmapbutton(self.window,wx.NewId(),self.img_first,style=buttonstyle)
	    self.sizer.Add(self.btn_first)
	    self.btn_first.help=_("Goto the first record [home]")
	    self.btn_first.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
	    self.btn_first.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
	    self.btn_first.Bind(wx.EVT_BUTTON,self.window.OnNavFirst)
        # previous record
        self.img_prev = artbitmap("navprev.png")
        self.btn_prev = freebitmapbutton(self.window,wx.NewId(),self.img_prev,style=buttonstyle)
        self.sizer.Add(self.btn_prev)
        self.btn_prev.help=_("Goto the previous record [pgdn]")
        self.btn_prev.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_prev.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_prev.Bind(wx.EVT_BUTTON,self.window.OnNavPrev)
        # next record
        self.img_next = artbitmap("navnext.png")
        self.btn_next = freebitmapbutton(self.window,wx.NewId(),self.img_next,style=buttonstyle)
        self.sizer.Add(self.btn_next)
        self.btn_next.help=_("Goto next record [pgup]")
        self.btn_next.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_next.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_next.Bind(wx.EVT_BUTTON,self.window.OnNavNext)
	if wx.Platform != "__WXGTK__":
	    # last record
	    self.img_last = artbitmap("navlast.png")
	    self.btn_last = freebitmapbutton(self.window,wx.NewId(),self.img_last,style=buttonstyle)
	    self.sizer.Add(self.btn_last)
	    self.btn_last.help=_("Goto last record [end]")
	    self.btn_last.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
	    self.btn_last.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
	    self.btn_last.Bind(wx.EVT_BUTTON,self.window.OnNavLast)
	else:
	    self.recordslider = wx.Slider(self.window,wx.NewId(),1,1,2,size=(100,32),style=wx.SL_HORIZONTAL | wx.SL_LABELS)
	    self.sizer.Add(self.recordslider)
	    self.recordslider.Bind(wx.EVT_SCROLL_CHANGED,self.window.OnNavSlider)
        # ommit
        self.img_ommit = artbitmap("navommit.png")
        self.btn_ommit = freebitmapbutton(self.window,wx.NewId(),self.img_ommit,style=buttonstyle)
        self.sizer.Add(self.btn_ommit)
        self.btn_ommit.help=_("Ommit this record [o]")
        self.btn_ommit.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_ommit.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_ommit.Bind(wx.EVT_BUTTON,self.window.OnNavOmmit)
        # delete
        self.img_delete = artbitmap("navdelete.png")
        self.btn_delete = freebitmapbutton(self.window,wx.NewId(),self.img_delete,style=buttonstyle)
        self.sizer.Add(self.btn_delete)
        self.btn_delete.help = _("Delete this record [d]")
        self.btn_delete.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_delete.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_delete.Bind(wx.EVT_BUTTON,self.window.OnNavDelete)
        # print
        self.img_print = artbitmap("navprint.png")
        self.btn_print = freebitmapbutton(self.window,wx.NewId(),self.img_print,style=buttonstyle)
        self.sizer.Add(self.btn_print)
        self.btn_print.help = _("Print Record [p]")
        self.btn_print.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_print.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_print.Bind(wx.EVT_BUTTON,self.window.OnNavPrint)
        # export
        self.img_export = artbitmap("navexport.png")
        self.btn_export = freebitmapbutton(self.window,wx.NewId(),self.img_export,style=buttonstyle)
        self.sizer.Add(self.btn_export)
        self.btn_export.help= _("Export records")
        self.btn_export.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_export.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_export.Bind(wx.EVT_BUTTON,self.window.OnNavExport)
        # import 
        self.img_import = artbitmap("navimport.png")
        self.btn_import = freebitmapbutton(self.window,wx.NewId(),self.img_import,style=buttonstyle)
        self.sizer.Add(self.btn_import)
        self.btn_import.help=_("Import records")
        self.btn_import.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_import.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_import.Bind(wx.EVT_BUTTON,self.window.OnNavImport)
	# Show a list of the current recordset
        self.img_list = artbitmap("navlist.png")
        self.btn_list = freebitmapbutton(self.window,wx.NewId(),self.img_list,style=buttonstyle)
        self.sizer.Add(self.btn_list)
        self.btn_list.help=_("Show list")
        self.btn_list.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_list.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_list.Bind(wx.EVT_BUTTON,self.window.OnNavList)	
        # open another database, usefull esp. on mac
        self.img_import = artbitmap("navopen.png")
        self.btn_open = freebitmapbutton(self.window,wx.NewId(),self.img_import,style=buttonstyle)
        self.sizer.Add(self.btn_open)
        self.btn_open.help=_("Open another database")
        self.btn_open.Bind(wx.EVT_ENTER_WINDOW,self.window.OnNavHover)
        self.btn_open.Bind(wx.EVT_LEAVE_WINDOW,self.window.OnNavNoHover)
        self.btn_open.Bind(wx.EVT_BUTTON,self.window.OnNavOpen)
	self.check_disable()
    def check_disable(self):
	if len(self.disabled)==0:return
	rbool=False
	if "new" in self.disabled:self.btn_new.Enable(rbool)
        if "delete" in self.disabled:self.btn_delete.Enable(rbool)
        if "export" in self.disabled:self.btn_export.Enable(rbool)
	if wx.Platform != "__WXGTK__":
	    if "first" in self.disabled:self.btn_first.Enable(rbool)
        if "ifind" in self.disabled:self.btn_ifind.Enable(rbool)
        if "import" in self.disabled:self.btn_import.Enable(rbool)
	if wx.Platform != "__WXGTK__":
	    if "last" in self.disabled:self.btn_last.Enable(rbool)
        if "next" in self.disabled:self.btn_next.Enable(rbool)
        if "ommit" in self.disabled:self.btn_ommit.Enable(rbool)
        if "prev" in self.disabled:self.btn_prev.Enable(rbool)
        if "print" in self.disabled:self.btn_print.Enable(rbool)
        if "sort" in self.disabled:self.btn_sort.Enable(rbool)
        if "open" in self.disabled:self.btn_open.Enable(rbool)
	if "list" in self.disabled:self.btn_list.Enable(rbool)
	if wx.Platform == "__WXGTK__":
	    if "slider" in self.disabled:self.recordslider.Enable(rbool)
    def ShowSlider(self,rbool):
	if not "slider" in self.disabled:self.recordslider.Enable(rbool)
    def find_mode(self,bool=True):
        if bool:
            rbool=False
        else:
            rbool=True
	if not "new" in self.disabled:self.btn_new.Enable(rbool)
        if not "delete" in self.disabled:self.btn_delete.Enable(rbool)
        if not "export" in self.disabled:self.btn_export.Enable(rbool)
	if wx.Platform != "__WXGTK__":
	    if not "first" in self.disabled:self.btn_first.Enable(rbool)
        if not "ifind" in self.disabled:self.btn_ifind.Enable(rbool)
        if not "import" in self.disabled:self.btn_import.Enable(rbool)
	if wx.Platform != "__WXGTK__":
	    if not "last" in self.disabled:self.btn_last.Enable(rbool)
        if not "next" in self.disabled:self.btn_next.Enable(rbool)
        if not "ommit" in self.disabled:self.btn_ommit.Enable(rbool)
        if not "prev" in self.disabled:self.btn_prev.Enable(rbool)
        if not "print" in self.disabled:self.btn_print.Enable(rbool)
        if not "sort" in self.disabled:self.btn_sort.Enable(rbool)
        if not "open" in self.disabled:self.btn_open.Enable(rbool)
	if not "list" in self.disabled:self.btn_list.Enable(rbool)
	if wx.Platform == "__WXGTK__":
	    if not "slider" in self.disabled:self.recordslider.Enable(rbool)
class Ifindwin(wx.Dialog):
    """ The Ifindwin is a general find window wich allows interactive find,the I stands for interactive"""
    def __init__(self,parent,db,table,columns,primary,limit,flen=3):
        wx.Dialog.__init__(self,parent,wx.NewId(),_("Find"))
        self.primary=primary
	self.limit = limit
        self.gsizer = wx.BoxSizer(wx.VERTICAL)
        self.columns=columns
        self.table = table
	self.flen=flen
        self.db = db
        self.fields =[]
        self.selectedkeys = []
        i=0
        self.resultlist = wx.ListCtrl(self,wx.NewId(),style=wx.LC_REPORT | wx.LC_NO_SORT_HEADER)
        self.resultlist.Bind(wx.EVT_LIST_COL_BEGIN_DRAG,lambda event:event.Veto())
        self.resultlist.Bind(wx.EVT_LIST_ITEM_ACTIVATED,self.returnselected)
        fsizer = wx.BoxSizer(wx.HORIZONTAL)
        for c in self.columns:
            f = fieldwithlabel(self,c[0],c[1],maxlen=20,height=27,nolabel=True)
            #self.gsizer.Add(f.label,(0,i))
            fsizer.Add(f.field)
            #self.gsizer.Add(f.field,(0,i),flag=wx.LEFT)
            self.fields.append(f)
            f.field.Bind(wx.EVT_KEY_UP,self.dofind)
            self.resultlist.InsertColumn(i,c[0])
	    if self.limit==None:
		self.resultlist.SetColumnWidth(i,f.GetWidth())
	    else:
		self.resultlist.SetColumnWidth(i,f.GetWidth()-(20/len(self.columns)))
            i+=1
        self.gsizer.Add(fsizer)
        self.gsizer.AddSpacer((5,5))
        self.gsizer.Add(self.resultlist,wx.EXPAND,flag=wx.GROW) #,(1,0),(1,len(self.columns)),wx.EXPAND)
	self.resultlist.Bind(wx.EVT_LIST_ITEM_SELECTED,self.OnSelect)
        self.buttonsizer = wx.BoxSizer(wx.HORIZONTAL)
        self.gsizer.Add(self.buttonsizer) #,(2,0),(1,len(self.columns)),wx.EXPAND)
        self.okbut = wx.Button(self,wx.NewId(),_("OK"))
        self.okbut.Bind(wx.EVT_BUTTON,self.returnselected)
        self.buttonsizer.Add(self.okbut)
        
        #self.gsizer.Add(self.okbut,(2,0),(1,2))
        self.cancelbut = wx.Button(self,wx.NewId(),_("Close"))
        self.cancelbut.Bind(wx.EVT_BUTTON,lambda event:self.Close())
        #self.gsizer.Add(self.cancelbut,(2,2),(1,2))
        self.buttonsizer.Add(self.cancelbut)
	
	self.appendtoselection = wx.CheckBox(self,wx.NewId(),_("Append to selection"))
	self.buttonsizer.Add(self.appendtoselection)
        
        self.SetSizerAndFit(self.gsizer)
        self.SetSize((self.GetSize()[0],400))
        self.fields[0].field.SetFocus()
        self.gsizer.Layout()
        self.CenterOnParent()
        self.ShowModal()
    def OnSelect(self,event):
	# If the user selected more..., refind with limit (2000)
	if self.resultlist.GetItemText(event.GetIndex()) == _("More..."):
	    self.limit=4000
	    self.dofind(event)
	else:
	    event.Skip()
    def returnselected(self,event):
        self.selectedkeys = []
        for i in range(self.resultlist.GetItemCount()):
            if self.resultlist.IsSelected(i):self.selectedkeys.append(self.data[i])
        if len(self.selectedkeys)>0:self.Close()
    def dofind(self,event):
        key = event.GetKeyCode()
        if key==9:
            event.Skip()
            return
        # here the find is done, standard behaviour is only to fetch 200 record and only search text field when you entered more than 3 letters
        # int fields are exact, text is not, date is
        self.selectedkeys = []
        fieldnames=[self.primary]
        for f in self.fields:
            fieldnames.append(f.textlabel)
        first =True
        findcondition=""
        for f in self.fields:
            value = f.GetDbValue()
            name = f.textlabel
            type = f.type
            print name,value,type
            if value<>None:
                if type in ("varchar","text"):
                    if len(value)>=self.flen:
                        if first:
                            findcondition+="where %s ~* '%s' "%(name,S(value))
                            first=False
                        else:
                            findcondition+="and %s ~* '%s'"%(name,S(value))
                elif type in ("char"):
                    if first:
                        findcondition+="where %s = '%s' "%(name,S(value))
                        first=False
                    else:
                        findcondition+="and %s = '%s'"%(name,S(value))
                elif type in ("date"):
		    # a bit of a problem to search interactive
		    # let's try saying the lengte of value needs to be >= 10 xx/xx/xx
		    if len(value)<8:
			pass
		    else:
			if first:
			    findcondition+="where %s = '%s' "%(name,S(value))
			    first=False
			else:
			    findcondition+="and %s = '%s'"%(name,S(value))
                elif type in ("int8","int4"):
                    if first:
                        findcondition+="where %s = %s "%(name,S(value))
                        first=False
                    else:
                        findcondition+="and %s = %s "%(name,S(value))
                else:
                    # assumeptype or other string like
                    if first:
                        findcondition+="where %s::text ~* '%s' "%(name,S(value))
                        first=False
                    else:
                        findcondition+="and %s::text ~* '%s'"%(name,S(value))
        if self.resultlist.GetItemCount()>0:self.resultlist.DeleteAllItems()
        if findcondition=="":return
        limit = self.resultlist.GetSize()[1]/25
	if self.limit<>None:limit=self.limit
	# Is there any reason to sort on the pkey ?
        sql = "select %s from %s %s order by %s offset 0 limit %s;"%(string.join(fieldnames,","),self.table,findcondition,string.join(fieldnames[1:],","),limit +1)
        print sql
        cursor = self.db.cursor()
        #try:
        cursor.execute(str(sql))
        #except:
        #    
        #    w = wx.MessageBox("error","error",style=wx.OK)
        #    return
        if cursor.error:
	    self.db.rollback()
            wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
            return
        data = cursor.fetchall()
	if len(data)>limit:
	    more = True
	    data = data[:len(data)-2]
	else:
	    more = False
        i=0
        self.data = {}
        for record in data:
            if record[1]==None:
                self.resultlist.InsertStringItem(i,"")
            else:
                self.resultlist.InsertStringItem(i,str(record[1]))
            t=1
            for field in record[2:]:
                if field==None:
                    self.resultlist.SetStringItem(i,t,"")
                else:
                    self.resultlist.SetStringItem(i,t,str(field))
                t+=1
            self.data[i]=record[0]
            i+=1
	if more:
	    self.resultlist.InsertStringItem(i,_("More..."))
	    self.resultlist.SetItemBackgroundColour(i,"#eeaaaa")
class Blobfield:
    def __init__(self,parent,db,tablename,pfield,fieldname,xml=None):
	self.md5=None
        self.span=6
        self.picsize =(200,150) # was 256,150
	
        self.name = fieldname
        self.label = wx.StaticText(parent,wx.NewId(),str(fieldname))
        self.sizer = wx.BoxSizer(wx.VERTICAL)
        self.picbox = wx.StaticBitmap(parent,wx.NewId(),size=self.picsize)
        self.functionsizer = wx.BoxSizer(wx.HORIZONTAL)
        self.sizer.Add(self.picbox)
        self.sizer.Add(self.functionsizer)
	f = wx.Font(9,wx.FONTFAMILY_DEFAULT,wx.FONTSTYLE_NORMAL,wx.FONTWEIGHT_NORMAL)

        self.importbut = wx.Button(parent,wx.NewId(),_("Import..."),style=wx.BU_EXACTFIT)
        self.importbut.Bind(wx.EVT_BUTTON,self.loadfromfile)
	self.importbut.SetFont(f)
        self.functionsizer.Add(self.importbut)
        self.exportbut = wx.Button(parent,wx.NewId(),_("Save..."),style=wx.BU_EXACTFIT)
	self.exportbut.SetFont(f)
        self.functionsizer.Add(self.exportbut)
        self.exportbut.Bind(wx.EVT_BUTTON,self.SaveToFile)
        self.deletebut = wx.Button(parent,wx.NewId(),_("Delete"),style=wx.BU_EXACTFIT)
	self.deletebut.SetFont(f)
        self.deletebut.Bind(wx.EVT_BUTTON,self.Deletefromdb)
        self.functionsizer.Add(self.deletebut)
        self.pkey=None
        self.xml=xml
        self.db=db
        self.fieldname=fieldname
        self.pfield = pfield
        self.tablename = tablename
        self.parent=parent
        self.ESCAPE_LIST = [] #[39,92]
        #for i in range(0,32):self.ESCAPE_LIST.append(i)
        for i in range(256):self.ESCAPE_LIST.append(i)
        for i in range(126-32):self.ESCAPE_LIST.remove(i+32)
        self.ESCAPE_LIST.append(39)
        self.ESCAPE_LIST.append(92)
        #self.ESCAPE_LIST.remove(47)
        self.emptyimage = artbitmap("empty.png")
        self.picbox.SetBitmap(self.emptyimage)
    def GetImg(self):
        return self.picbox.GetBitmap()
    def SetVal(self,value):
        print "This function should not be used !!!"
    def SaveToFile(self,event):
        if self.pkey==None:return
        if not self.has_image:return
        if self.filetype==None:
            w = wx.FileDialog(self.parent,_("Save"),home,"file",style=wx.SAVE)
        else:
            w = wx.FileDialog(self.parent,_("Save"),home,"file.%s"%self.filetype,style=wx.SAVE)
        if w.ShowModal()==wx.ID_OK:
            of = file(w.GetPath(),"w")
            of.write(self.data)
    def find_mode(self,bool=True):
        self.picbox.SetBitmap(self.emptyimage)
	self.md5=None
    def GetDbValue(self):
        return None
    def Deletefromdb(self,event):
        if self.has_image:
            cursor = self.db.cursor()
	    if str(type(self.pkey))=="<type 'str'>":
		cursor.execute("update %s set %s=null where %s='%s';"%(self.tablename,self.fieldname,self.pfield,self.pkey))
	    else:
		cursor.execute("update %s set %s=null where %s=%s;"%(self.tablename,self.fieldname,self.pfield,self.pkey))
            self.db.commit()
            self.loadfromdb(self.pkey)
    def loadfromdb(self,pkey):
        self.pkey=pkey
        
        if self.pkey==None:
            self.picbox.SetBitmap(self.emptyimage)
            return False
        cursor = self.db.cursor()
	if str(type(pkey))=="<type 'str'>":
	    cursor.execute("select md5(%s) from %s where %s='%s';"%(self.fieldname,self.tablename,self.pfield,self.pkey))
	else:
	    cursor.execute("select md5(%s) from %s where %s=%s;"%(self.fieldname,self.tablename,self.pfield,self.pkey))
	data = cursor.fetchall()
	if not len(data)==0:
	    if not data[0][0]==None:
		if self.md5==data[0][0]:
		    # Skip, loaded image is the same as db image
		    print "Not reloading image, hasn't changed %s=%s"%(self.md5,data[0][0])
		    return True # What to return here ?
		else:
		    print "Setted md5 %s <> %s"%(self.md5,data[0][0])
		    self.md5=data[0][0]
	self.has_image=False
        self.filetype=None	
	print "Loading image..."
	if str(type(pkey))=="<type 'str'>":
	    cursor.execute("select %s from %s where %s='%s';"%(self.fieldname,self.tablename,self.pfield,self.pkey))
	else:
	    cursor.execute("select %s from %s where %s=%s;"%(self.fieldname,self.tablename,self.pfield,self.pkey))
	if cursor.error:
	    self.db.rollback()
            wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
        data = cursor.fetchall()
        if len(data)==0:
            self.picbox.SetBitmap(self.emptyimage)
	    self.md5=None
            return False
        data = data[0][0] # no support for arrays just yet
        if data==None or data=="":
            self.picbox.SetBitmap(self.emptyimage)
	    self.md5=None
            return False
        # the other escape list
        for E in self.ESCAPE_LIST:
            q  = "\\%s"%string.rjust(str(oct(E)),4,"0")[1:]
            data = string.replace(data,q,chr(E))
        data = string.replace(data,"\\\\","\\")
        self.data=data
        # try and guess file type
        #print data[:2000]
        self.filetype = get_ext_fromdata(data[:128])
        vfile = StringIO.StringIO(data)
        #vfile.write(data)
        #vfile.flush()
        #x = wx.MimeTypesManager()
        #of = file("/tmp/test.gif","w")
        #of.write(data)
        #of.close()
        nolog = wx.LogNull()
        img = wx.ImageFromStream(vfile)
        del nolog
	try:
        	img_x = img.GetWidth()
        	img_y = img.GetHeight()
	except:
		img_x=0;img_y=0
        if img_x ==0 or img_y==0:
            # not so sure if this is the "way"
            # now load the file image
            self.emptyimage = artbitmap("file.png")
            self.picbox.SetBitmap(self.emptyimage)
            self.has_image=True # I think
            return
        scalefac_x = float(self.picsize[0])/img_x
        scalefac_y = float(self.picsize[1])/img_y
        scalefac = min(scalefac_x,scalefac_y)
        img = img.Scale(int(img_x*scalefac),int(img_y*scalefac))
        bitmap = wx.BitmapFromImage(img)
        self.picbox.SetBitmap(bitmap)
        self.has_image=True

    def loadfromfile(self,event):
        if self.pkey==None:return
	sdir = home
	if self.xml<>None:
	    if self.xml.getprop("sdir"):sdir=self.xml.getprop("sdir")
        w = wx.FileDialog(self.parent,_("Choose a file"),sdir,style=wx.OPEN | wx.FILE_MUST_EXIST)
        if w.ShowModal()==wx.ID_OK:
            path = w.GetPath()
            # open the file
            datafile = file(path)
            normal=True
	    print self.xml
	    print path
	    if self.xml<>None and ("jpg" in path.lower()): # not so nice
		if "x" in self.xml.getprop("resize"):
		    normal=False
		    width,height=self.xml.getprop("resize").split("x")
		    # this kind of forces 
		    img = wx.ImageFromStream(datafile)
		    img.Rescale(int(width),int(height),wx.IMAGE_QUALITY_HIGH)
		    b = wx.BitmapFromImage(img)
		    newpath = path + ".scaled.jpg"
		    img.SaveFile(newpath,wx.BITMAP_TYPE_JPEG)
		    newdatafile = file(newpath)
		    data = newdatafile.read()
		    print "Image resized"
	    if normal:
		data = datafile.read()
	    if self.xml<>None:
		if self.xml.getprop("aftermove"):
		    d = self.xml.getprop("aftermove")
		    if not os.path.isdir(d):
			sh = os.popen("mkdir %s"%d)
			t = sh.read()
		    if os.path.isdir(d):
			dummy=path.split("/")
			fname=dummy[len(dummy)-1]
			sh = os.popen("mv %s %s/%s"%(path,d,fname))
			t = sh.read()
			if normal==False:
			    sh = os.popen("mv %s.scaled.jpg %s/%s.scaled.jpg"%(path,d,fname))
			t = sh.read()
            # escape some stuff
            newdata = ""
            for d in data:
                if ord(d) in self.ESCAPE_LIST:
                    newdata += "\\\\%s"%string.rjust(str(oct(ord(d))),4,"0")[1:]
                    #if "\\\%s"%string.rjust(str(ord(d)),3,"0")=="\\\097":
                    #print d,ord(d),string.rjust(str(ord(d)),3,"0")
                else:
                    newdata += d
            cursor = self.db.cursor()
	    if str(type(self.pkey))=="<type 'str'>":
		sql = "update %s set %s=E'%s'::bytea where %s='%s';"%(self.tablename,self.fieldname,newdata,self.pfield,self.pkey)
	    else:
		sql = "update %s set %s=E'%s'::bytea where %s=%s;"%(self.tablename,self.fieldname,newdata,self.pfield,self.pkey)
            sql = str(sql)
            #sql = "update %s set %s='\\\\102'::bytea where %s=%s;"%(self.tablename,self.fieldname,self.pfield,self.pkey)
            cursor.execute(sql)
	    if cursor.error:
		self.db.rollback()
                wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
		
            self.db.commit()
            self.loadfromdb(self.pkey)
        
class RecordPrintout(wx.Printout):
    def __init__(self,fields,portals,data,title,margins,parent):
        wx.Printout.__init__(self,title)
        self.data = data
        self.margins = margins
        self.fields =fields
        self.parent=parent
        self.portals = portals
        # try and find an xml template
        self.xml=None
        xmlpath = os.path.join(wx.StandardPaths_Get().GetUserDataDir(),"templates","%s_print.xml"%parent.table)
        if os.path.exists(xmlpath):
            try:
                self.xml=templates.xmltemplate(xmlpath)
            except:
                wx.MessageBox(_("There was a problem with xml file %s"%xmlpath),_("error"),style=wx.OK)
                self.xml=None
            print self.xml
    def CalculateScale(self,dc):
        ppiPrinterX,ppiPrinterY = self.GetPPIPrinter()
        ppiScreenX,ppiScreenY = self.GetPPIScreen()
        logscale = float(ppiPrinterX)/float(ppiScreenX)
        pw , ph = self.GetPageSizePixels()
        d =  dc.GetSize()
        dw=d[0]
        dh = d[1]
        scale = logscale  * float(dw)/float(pw)
	# Here we have a problem, we got this from the net but it doens't work at all on mac, on linux it's also rather useless
	# for the moment we'll always set scale to 1 on a mac
	if wx.Platform=="__WXMAC__":scale=1
        dc.SetUserScale(scale,scale)
        self.logUnitsMM = float(ppiPrinterX)/(logscale*25.4)
	print "actual scale:%s"%scale
	print "calculated scale:%s"%self.logUnitsMM
	print self.GetPPIPrinter()
	print self.GetPPIScreen()
	print self.GetPageSizePixels()
	print dc.GetSize()
	print dc.GetUserScale()
    def CalculateLayout(self,dc):
        topLeft,bottomRight = self.margins
        d =  dc.GetSize()
        dw=d[0]
        dh = d[1]
        self.x1 = topLeft.x * self.logUnitsMM
        self.y1 = topLeft.y * self.logUnitsMM
        self.x2 = (dc.DeviceToLogicalXRel(dw) - bottomRight.x * self.logUnitsMM)
        self.y2 = (dc.DeviceToLogicalYRel(dh) - bottomRight.y * self.logUnitsMM)
        self.PageHeight = self.y2 - self.y1 - 2*self.logUnitsMM
        font =wx.Font(10,wx.TELETYPE,wx.NORMAL,wx.NORMAL)
        dc.SetFont(font)
        self.lineHeight = dc.GetCharHeight()
        self.linesPerPage = int(self.PageHeight/self.lineHeight)
	print "lines per page:%s"%self.linesPerPage
    def OnPrintPage(self,page):
        dc = self.GetDC()
        if 1==9:dc=wx.DC()
        self.CalculateScale(dc)
        self.CalculateLayout(dc)
        dc.SetPen(wx.Pen("black",0))
        dc.SetBrush(wx.TRANSPARENT_BRUSH)
        #r = wx.RectPP((self.x1,self.y1),(self.x2,self.y2))
        #dc.DrawRectangleRect(r)
        #dc.SetClippingRect(r)
        self.portalprogress={}
        self.basepage(dc)
        
        self.doportals(dc)
        self.doback(dc)
        return True
    def doback(self,dc):
        # if the xml has a back element we print it on page 2 for duplex printing
        # for invoices and stuff
        if self.xml:
            for x in self.xml.xmlitems:
                if x.getname()[:4]=="back":
                    dc.EndPage()
                    dc.StartPage()
                    dc.SetPen(wx.Pen("black",0))
                    dc.SetBrush(wx.TRANSPARENT_BRUSH)
                    dc.Clear()
                    t=x.getprop("otext")
                    if x.getprop("center")=="True":
                        ext = dc.GetTextExtent(t)
                        dc.DrawText(t,(x.posx()*self.logUnitsMM)-(ext[0]/2),x.posy()*self.logUnitsMM)
                    else:
                        dc.DrawText(t,x.posx()*self.logUnitsMM,x.posy()*self.logUnitsMM)
                    
                    
    def basepage(self,dc):
        self.offsety=24
        i=0
        fonthelp = xmlfonthelper(dc.GetFont())
        for f in self.fields:
            if f[1]<>"bytea":
                t= str(f[0])
                
                if self.xml:
                    xml=self.xml.item("label_%s"%f[0])
                else:
                    xml=None
                dc.SetFont(fonthelp.getfont(xml))
                extent = dc.GetTextExtent(str(f[0]))
                if xml==None:
                    dc.DrawText(str(f[0]),(55*self.logUnitsMM)-extent[0],self.offsety*self.logUnitsMM)
                else:
                    if xml.getprop("otext"):t=xml.getprop("otext")
                    if not xml.getprop("hide")=="True":dc.DrawText(t,(xml.posx()*self.logUnitsMM),xml.posy()*self.logUnitsMM)
                
                if self.xml:
                    xml=self.xml.item("field_%s"%f[0])
                else:
                    xml=None
                dc.SetFont(fonthelp.getfont(xml))
                extent2 = dc.GetTextExtent(str(self.data[f[0]]))
                if self.data[f[0]]<>None:
                    if xml==None:
                        dc.DrawText(str(self.data[f[0]]),60*self.logUnitsMM,self.offsety*self.logUnitsMM)
                    else:
                        if not xml.getprop("hide")=="True":dc.DrawText(str(self.data[f[0]]),xml.posx()*self.logUnitsMM,xml.posy()*self.logUnitsMM)
                if extent2[1]>0:
                    self.offsety+=extent2[1]/self.logUnitsMM
                else:
                    self.offsety+=dc.GetTextExtent("T")[0]/self.logUnitsMM
                self.offsety+=5/self.logUnitsMM
            else:
                if self.xml:
                    xml=self.xml.item("label_%s"%f[0])
                else:
                    xml=None
                dc.SetFont(fonthelp.getfont(xml))
                extent = dc.GetTextExtent(str(f[0]))
                if xml==None:
                    dc.DrawText(str(f[0]),(55*self.logUnitsMM)-extent[0],self.offsety*self.logUnitsMM)
                else:
                    dc.DrawText(str(f[0]),(xml.posx()*self.logUnitsMM),xml.posy()*self.logUnitsMM)
                if self.xml:
                    xml=self.xml.item("field_%s"%f[0])
                else:
                    xml=None
                bitmap = self.parent.fields[i].GetImg()
                if xml==None:
                    dc.DrawBitmap(bitmap,60*self.logUnitsMM,self.offsety*self.logUnitsMM)
                else:
                    dc.DrawBitmap(bitmap,xml.posx()*self.logUnitsMM,xml.posy()*self.logUnitsMM)
                self.offsety+=bitmap.GetHeight()/self.logUnitsMM
            i+=1
        if self.xml:
            for x in self.xml.xmlitems:
                if x.getname()[:4]=="logo":
                    path = os.path.join(wx.StandardPaths_Get().GetUserDataDir(),"art",x.getprop("filename"))
                    bm = wx.Bitmap(path)
                    dc.DrawBitmap(bm,x.posx()*self.logUnitsMM,x.posy()*self.logUnitsMM)
                elif x.getname()[:4]=="line":
                    dc.DrawLine(x.posx()*self.logUnitsMM,x.posy()*self.logUnitsMM,int(x.getprop("x2"))*self.logUnitsMM,int(x.getprop("y2"))*self.logUnitsMM)
                elif x.getname()[:4]=="text":
                    dc.SetFont(fonthelp.getfont(x))
                    if x.getprop("center")=="True":
                        t = x.getprop("otext")
                        ext = dc.GetTextExtent(t)
                        dc.DrawText(t,(x.posx()*self.logUnitsMM)-(ext[0]/2),x.posy()*self.logUnitsMM)
                    else:
                        dc.DrawText(x.getprop("otext"),x.posx()*self.logUnitsMM,x.posy()*self.logUnitsMM)
                elif x.getname()[:4]=="stat":
                    dc.SetFont(fonthelp.getfont(x))
                    cursor = self.parent.db.cursor()
                    sql = string.replace(x.getprop("sql"),"$primary",str(self.parent.currentpkey))
		    sr = []
		    for r in self.parent.recordset:sr.append(str(r))
		    sql = sql.replace("$keys",",".join(sr))
                    cursor.execute(sql)
                    if cursor.error:
			self.parent.db.rollback()
                        wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
                        
                    sdata=cursor.fetchall()
                    if len(sdata)==1:
                        dc.DrawText(str(sdata[0][0]),x.posx()*self.logUnitsMM,x.posy()*self.logUnitsMM)            
                elif x.getname()[:4]=="rect":
                    dc.DrawRectangle(x.posx()*self.logUnitsMM,x.posy()*self.logUnitsMM,int(x.getprop("width"))*self.logUnitsMM,int(x.getprop("height"))*self.logUnitsMM)
        for p in self.portals:
            self.portalprogress[str(p)]=0
            pheight=0
            xmlname = "portal_%s"%p.table
            if self.xml:
                xml = self.xml.item(xmlname)
            else:
                xml = None
            width=150
            height=1000
	    if xml<>None:
		if xml.getprop("hide"):continue
		if xml.getprop("width"):width=int(xml.getprop("width"))
		if xml.getprop("height"):height=int(xml.getprop("height"))
            fieldnames = p.fieldnames
            if xml<>None:
		if xml.getprop("fields"):fieldnames=string.split(xml.getprop("fields"),",")
            afieldnames=[]
            asql=[]
	    if xml<>None:
		if xml.getprop("add"):afieldnames = string.split(xml.getprop("add"),"$$")
		if xml.getprop("addsql"):asql = string.split(xml.getprop("addsql"),"$$")
                    
            cwidth=round((width/(len(fieldnames)+len(afieldnames)))*self.logUnitsMM)
            cw=[]
            if xml==None:
		for i in range(len(fieldnames)+len(afieldnames)):cw.append(cwidth)
            elif xml.getprop("colwidths"):
                widths = string.split(xml.getprop("colwidths"),",")
                cws=0
                for w in widths:cws+=int(w)
                scw=width/cws #cws/(len(fieldnames)+len(afieldnames))
                tt=0
                for i in range(len(fieldnames)+len(afieldnames)-1):
                    t= int(scw*int(widths[i])*self.logUnitsMM)
                    tt+=t
                    cw.append(t)
                cw.append((width*self.logUnitsMM-tt))
            else:
                for i in range(len(fieldnames)+len(afieldnames)):cw.append(cwidth)
            offsetx = round(20*self.logUnitsMM)
            ex = int(dc.GetTextExtent("Tj")[1]*1.4)
            if 2==3:p= dbportal()
            colnum = len(p.fieldnames)
            fields = fieldnames
            fieldnums = []
            for fn in fieldnames:
                s=0
                for f in p.fieldnames:
                    if fn==f:
                        fieldnums.append(s)
                    s+=1
            recnum = len(p.data)
            posx=offsetx
            posy = self.offsety
            rofx = 0

            if xml:
                posx = xml.posx()
                posy = xml.posy()
            posx=posx*self.logUnitsMM
            posy=posy*self.logUnitsMM
            # draw a box thing
            i=0
            dc.SetBrush(wx.LIGHT_GREY_BRUSH)
            for f in fields:
                dc.DrawRectangle(posx+rofx,posy,cw[i],ex)
                dc.DrawText(str(f),posx+rofx,posy)
                rofx+=cw[i]
                i+=1
            for f in afieldnames:
                dc.DrawRectangle(posx+rofx,posy,cw[i],ex)
                dc.DrawText(str(f),posx+rofx,posy)
                rofx+=cw[i]
                i+=1
            posy+=ex
            dc.SetBrush(wx.TRANSPARENT_BRUSH)
            pheight=ex
            y=0

            self.basy = posy

    def doportals(self,dc):
        # portals come last, everything above this can be considered the base page
        for p in self.portals:
            self.portalprogress[str(p)]=0
            pheight=0
            xmlname = "portal_%s"%p.table
	    print xmlname
            if self.xml:
                xml = self.xml.item(xmlname)
            else:
                xml = None
            width=150
            height=1000
	    if xml<>None:
		if xml.getprop("hide"):continue
		if xml.getprop("width"):width=int(xml.getprop("width"))
		if xml.getprop("height"):height=int(xml.getprop("height"))
            fieldnames = p.fieldnames
            if xml<>None:
		if xml.getprop("fields"):fieldnames=string.split(xml.getprop("fields"),",")
            afieldnames=[]
            asql=[]
	    if xml<>None:
		if xml.getprop("add"):afieldnames = string.split(xml.getprop("add"),"$$")
		if xml.getprop("addsql"):asql = string.split(xml.getprop("addsql"),"$$")
                    
            cwidth=round((width/(len(fieldnames)+len(afieldnames)))*self.logUnitsMM)
            cw=[]
            if xml==None:
		for i in range(len(fieldnames)+len(afieldnames)):cw.append(cwidth)
            elif xml.getprop("colwidths"):
                widths = string.split(xml.getprop("colwidths"),",")
                cws=0
                for w in widths:cws+=int(w)
                scw=width/cws #cws/(len(fieldnames)+len(afieldnames))
                tt=0
                for i in range(len(fieldnames)+len(afieldnames)-1):
                    t= int(scw*int(widths[i])*self.logUnitsMM)
                    tt+=t
                    cw.append(t)
                cw.append((width*self.logUnitsMM-tt))
            else:
                for i in range(len(fieldnames)+len(afieldnames)):cw.append(cwidth)
            offsetx = round(20*self.logUnitsMM)
            ex = int(dc.GetTextExtent("Tj")[1]*1.4)
            if 2==3:p= dbportal()
            colnum = len(p.fieldnames)
            fields = fieldnames
            fieldnums = []
            for fn in fieldnames:
                s=0
                for f in p.fieldnames:
                    if fn==f:
                        fieldnums.append(s)
                    s+=1
            recnum = len(p.data)
            posx=offsetx
            posy = self.offsety
            rofx = 0

            if xml:
                posx = xml.posx()
                posy = xml.posy()
            posx=posx*self.logUnitsMM
            posy=posy*self.logUnitsMM
            # draw a box thing
            i=0

            posy+=ex
            dc.SetBrush(wx.TRANSPARENT_BRUSH)
            pheight=ex
            y=0

            self.basy = posy
            for rec in p.data[self.portalprogress[str(p)]:]:
                if not (pheight/self.logUnitsMM)<height:
                    # somehow start a new page
                    print "Next page ?"
                    self.doback # when a back is supposed to be done do one for every front
                    posy=self.basy
                    pheight=0
                    dc.EndPage()
                    dc.StartPage()
                    dc.SetPen(wx.Pen("black",0))
                    dc.SetBrush(wx.TRANSPARENT_BRUSH)
                    dc.Clear()
                    self.basepage(dc)
                vex=ex
                i=0
                rofx=0
                for f in fields:
                    if rec[fieldnums[i]]<>None:
                        # check if it will fit
                        e = dc.GetTextExtent(str(rec[fieldnums[i]]))[0]
                        if (e+30)<=cw[i]:
                            dc.DrawText(str(rec[fieldnums[i]]),posx+rofx,posy)
                        else:
                            words = string.split(str(rec[fieldnums[i]])," ")
                            tmpw=""
                            wc=0
                            for w in words:
                                print tmpw
                                print w,dc.GetTextExtent("%s %s"%(tmpw,w))[0],cw[i]
                                if (dc.GetTextExtent("%s %s"%(tmpw,w))[0]+30)<cw[i]: # and not w==words[len(words)-1]:
                                    if tmpw=="":
                                        tmpw=w
                                    else:
                                        tmpw += " %s"%w
                                else:
                                    # we should print this line, before it gets to big
                                    dc.DrawText(tmpw,posx+rofx,posy+(wc*ex))
                                    tmpw=w
                                    wc+=1
                                           
                            dc.DrawText(tmpw,posx+rofx,posy+(wc*ex))
                            vex=ex*(wc+1) 
                    #dc.DrawRectangle(posx+rofx,posy,cw[i],vex)
                    rofx+=cw[i]
                    i+=1
                    
                q=0
                for f in afieldnames:
                    cursor = self.parent.db.cursor()
                    cursor.execute(string.replace(asql[q],"$primary",str(rec[0])))
                    if cursor.error:
			self.parent.db.rollback()
                        wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
                        
                    data = cursor.fetchall()
                    if len(data)==1:
                        if data[0][0]<>None:
                            dc.DrawText(str(data[0][0]),posx+rofx,posy)
                    #dc.DrawRectangle(posx+rofx,posy,cw[i],vex)
                    rofx+=cw[i]
                    i+=1
                    q+=1
                i=0
                rofx=0
                for f in fields:
                    #if rec[fieldnums[i]]<>None:
                    dc.DrawRectangle(posx+rofx,posy,cw[i],vex)
                    rofx+=cw[i]
                    i+=1
                for f in afieldnames:
                    dc.DrawRectangle(posx+rofx,posy,cw[i],vex)
                    rofx+=cw[i]
                    i+=1
                    
                posy+=vex
                pheight+=vex
            self.offsety=posy
            y+=1
            self.portalprogress[str(p)]=y


class ConnectionWindow:
    def __init__(self):
        res = xrc.XmlResource("ui%sxrc%sconnectionwindow.xrc"%(os.sep,os.sep))
        self.dialog = res.LoadDialog(None,"connection_dialog")
        self.namefield = xrc.XRCCTRL(self.dialog,"namefield")
        if wx.Platform != "__WXMAC__":
            evt = wx.EVT_KILL_FOCUS
        else:
            evt = wx.EVT_KEY_UP
        self.namefield.Bind(wx.EVT_KILL_FOCUS,self.change)
        self.serverfield = xrc.XRCCTRL(self.dialog,"serverfield")
        self.serverfield.Bind(evt,self.change)
        self.portfield = xrc.XRCCTRL(self.dialog,"portfield")
        self.portfield.Bind(evt,self.change)
        self.dbfield = xrc.XRCCTRL(self.dialog,"dbfield")
        self.dbfield.Bind(evt,self.change)
        self.userfield = xrc.XRCCTRL(self.dialog,"loginfield")
        self.userfield.Bind(evt,self.change)
        self.passwordfield = xrc.XRCCTRL(self.dialog,"passwordfield")
        self.passwordfield.Bind(evt,self.change)
        self.tablefield = xrc.XRCCTRL(self.dialog,"tablefield")
        self.tablefield.Bind(evt,self.change)
        self.cancelbut = xrc.XRCCTRL(self.dialog,"cancelbut")
        self.deletebut = xrc.XRCCTRL(self.dialog,"deletebut")
        self.deletebut.Bind(wx.EVT_BUTTON,self.delete)
        self.namelist = xrc.XRCCTRL(self.dialog,"namelist")
        self.namelist.Bind(wx.EVT_LISTBOX,self.selectevt)
        self.cancelbut.Bind(wx.EVT_BUTTON,self.cancel)        
        self.okbut = xrc.XRCCTRL(self.dialog,"okbut")
        self.okbut.Bind(wx.EVT_BUTTON,self.ok)
        self.newbut = xrc.XRCCTRL(self.dialog,"newbut")
        self.newbut.Bind(wx.EVT_BUTTON,self.new)
        self.dialog.Bind(wx.EVT_CLOSE,self.save)
        # pref dialog
        prefdir = wx.StandardPaths_Get().GetUserDataDir()
        if not os.path.exists(prefdir):
            os.mkdir(prefdir)
        # make sure the templates directory exists
        if not os.path.exists(os.path.join(prefdir,"templates")):
            os.mkdir(os.path.join(prefdir,"templates"))
        # make sure the art directory exists
        if not os.path.exists(os.path.join(prefdir,"art")):
            os.mkdir(os.path.join(prefdir,"art"))
        # hostfiles
        self.hostfile = os.path.join(prefdir,"hosts")
        self.hostdic = {}
        i=0
        if os.path.exists(self.hostfile):
            f = file(self.hostfile)
            lines = string.split(f.read(),"\n")
            for line in lines:
                if line<>"":
                    try:
                        name,info = string.split(line,"$$$")
                        infolist = string.split(info,"$$")
                        self.hostdic[name]=infolist
                        i+=1
                    except:
                        print "Malformed config line"
            f.close()
        self.status=False
        self.loadlist()
        if 1==9:self.namelist=wx.ListBox()
        self.dialog.ShowModal()

    def delete(self,event):
        s = self.namelist.GetStringSelection()
        if s<>"":
            nc = self.hostdic.pop(s)
            self.namefield.SetValue("")
            self.serverfield.SetValue("")
            self.portfield.SetValue("")
            self.dbfield.SetValue("")
            self.userfield.SetValue("")
            self.passwordfield.SetValue("")
            self.tablefield.SetValue("")
            self.loadlist()
    def selectevt(self,event):
        s = self.namelist.GetStringSelection()
        if s<>"":
            self.select(s)
        event.Skip()
    def change(self,event):
        object = event.GetEventObject()
        if object==self.namefield:
            data = self.hostdic.pop(self.namelist.GetStringSelection())
            self.hostdic[self.namefield.GetValue()]=data
            self.loadlist(True)
            if wx.Platform == "__WXMAC__":
                self.select(self.namefield.GetValue())
        elif object==self.serverfield:
            self.hostdic[self.namefield.GetValue()][0]=self.serverfield.GetValue()
        elif object==self.portfield:
            self.hostdic[self.namefield.GetValue()][1]=self.portfield.GetValue()
        elif object==self.dbfield:
            self.hostdic[self.namefield.GetValue()][2]=self.dbfield.GetValue()
        elif object==self.userfield:
            self.hostdic[self.namefield.GetValue()][3]=self.userfield.GetValue()
        elif object==self.passwordfield:
            self.hostdic[self.namefield.GetValue()][4]=self.passwordfield.GetValue()
        elif object==self.tablefield:
            self.hostdic[self.namefield.GetValue()][5]=self.tablefield.GetValue()
    def save(self,event=None):
        # save the dictionary to the hosts file
        # should be 600 ? perm
        ofile = file(self.hostfile,"w")
        for k in self.hostdic.keys():
            t = k + "$$$"
            i = self.hostdic[k]
            t += string.join(i,"$$")
            ofile.write(t+"\n")
        ofile.close()
        os.chmod(self.hostfile,0700)
        if event:event.Skip()
        
            
            
    def loadlist(self,nof=False):
        while self.namelist.GetCount()>0:
            self.namelist.Delete(0)
        #if self.namelist.GetItemCount()>0:self.namelist.DeleteAllItems()
        i=0
	z=self.hostdic.keys()
	z.sort()
        for k in z:
            self.namelist.Insert(k,i)
            i+=1
	# select the first item, bug in wx
	if i>0 and not nof:
	    self.namelist.Select(0)
	    self.select(self.namelist.GetString(0))
    def new(self,event):
        if not self.hostdic.has_key("untitled"):
            self.hostdic["untitled"]=["","5432","","","",""] # server,port,db,login,pass,table
            self.loadlist()
            self.select("untitled")
            #self.namefield.SetValue("untitled")
    def select(self,name):
        self.namelist.SetStringSelection(name)
        self.namefield.SetValue(name)
        self.serverfield.SetValue(self.hostdic[name][0])
        self.portfield.SetValue(self.hostdic[name][1])
        self.dbfield.SetValue(self.hostdic[name][2])
        self.userfield.SetValue(self.hostdic[name][3])
        self.passwordfield.SetValue(self.hostdic[name][4])
        self.tablefield.SetValue(self.hostdic[name][5])
        
            
    def cancel(self,event):
        self.status=False
        self.dialog.MakeModal(False)
        self.dialog.Close()
    def ok(self,event):
        self.save()
        self.status=True
        self.params={}
        self.params["server"]=self.serverfield.GetValue()
        self.params["port"]=self.portfield.GetValue()
        self.params["username"]=self.userfield.GetValue()
        self.params["password"]=self.passwordfield.GetValue()
        self.params["table"]=self.tablefield.GetValue()
        self.params["database"]=self.dbfield.GetValue()
        self.dialog.MakeModal(False)
        self.dialog.Close()
class dbportal:
    def __init__(self,parent,table,db,tabledata,parenttable,parent_primary,parentfield,mylinkfield,xml=None):
        """ portal with grid, we will put the primary key in the label of the row"""
        self.grid = gridlib.Grid(parent,wx.NewId())
        self.xml=xml
        self.addcolums = []
	self.where=""
	self.name=None
	self.dportal=False
	self.overlaysql=None
	self.overlaydic={}
	if self.xml:
	    if self.xml.getname()[:7]=="dportal":
		self.name = self.xml.getname()[8:]
		self.dportal=True
		cursor = db.cursor()
		fields = [self.xml.getprop("primary"),mylinkfield]
		f = self.xml.getprop("fields").split("$$")
		for ff in f:fields.append(ff)
		print fields
		cursor.execute("select pg_attribute.attname,pg_type.typname,pg_attribute.atttypmod,pg_constraint.conkey,pg_attribute.attrelid,pg_class.relname from pg_attribute left outer join pg_type on (pg_type.oid = pg_attribute.atttypid) left outer join pg_class on (attrelid= pg_class.oid) left outer join pg_constraint on (pg_constraint.conrelid=pg_class.oid) where pg_class.relname='%s' and pg_attribute.attname in ('%s') and attnum>0 and attisdropped='f' and contype='p' order by attnum;"%(self.xml.getprop("table"),"','".join(fields)))
		tabledata = cursor.fetchall()
        if self.xml:
            if self.xml.getprop("add"):self.addcolums=string.split(self.xml.getprop("add"),"$$")
	    if self.xml.getprop("where"):self.where=self.xml.getprop("where")
	    if self.xml.getprop("overlaysql"):self.overlaysql=self.xml.getprop("overlaysql")
        self.sqladd = []
	self.staticsizer=False
	self.title=None
        if self.xml:
            if self.xml.getprop("addsql"):self.sqladd=string.split(self.xml.getprop("addsql"),"$$")
	    if self.xml.getprop("bg_color"):self.grid.SetLabelBackgroundColour(str(self.xml.getprop("bg_color")))
	    if self.xml.getprop("color"):self.grid.SetForegroundColour(str(self.xml.getprop("color")))
	    if self.xml.getprop("labelw"):self.grid.SetRowLabelSize(int(self.xml.getprop("labelw")))
	    if self.xml.getprop("title"):
		self.title=str(self.xml.getprop("title"))
		self.original_title = ""
	if self.staticsizer<>False and 0==1: #does not work for now
	    self.sizer = wx.StaticBoxSizer(wx.VERTICAL,parent,self.staticsizer)
	    self.sizer.Add(self.grid,wx.EXPAND)
	# We should also check which columns are enums, when clicked on these should present a dialog with their options
	print tabledata
	self.enum={}
	choices={}
	if self.xml:
		    if self.xml.getprop("choices"):
			dummy = self.xml.getprop("choices").split("$$")
			for d in dummy:
			    dum = d.split("=")
			    values = dum[1].split("|")
			    choices[dum[0]]=values
	
	for i in range(len(tabledata)):
	    if not tabledata[i][1] in KNOWN_TYPES:
		# enum ?
		cursor = parent.db.cursor()
		cursor.execute("select enumlabel from pg_type left outer join pg_enum on (pg_enum.enumtypid=pg_type.oid) where typname='%s';"%tabledata[i][1])
		data = cursor.fetchall()
		if len(data)>0:
		    enum=[]
		    ftype='enum'
		    for d in data:enum.append(d[0])
		    enum.append("")
		    self.enum[tabledata[i][0]]=enum
		    #self.grid.Bind(gridlib.EVT_GRID_CELL_LEFT_CLICK,self.OnClick)
		    self.grid.Bind(gridlib.EVT_GRID_SELECT_CELL,self.OnClick)
	    elif choices.has_key(tabledata[i][0]):
		self.enum[tabledata[i][0]]=choices[tabledata[i][0]]
		self.grid.Bind(gridlib.EVT_GRID_SELECT_CELL,self.OnClick)	

	print self.enum

	self.grid.CreateGrid(1,len(tabledata)-2+len(self.addcolums)) # not always right ?
        self.grid.Bind(gridlib.EVT_GRID_CELL_CHANGE,self.update)
	self.grid.Bind(gridlib.EVT_GRID_LABEL_RIGHT_CLICK,self.delete)
	self.grid.Bind(gridlib.EVT_GRID_CELL_RIGHT_CLICK,self.delete)
        self.parent=parent
        self.db = db
        self.table=table
        self.tabledata = tabledata
        self.parent_primary=parent_primary
        self.parent_key=None
        self.busy=False
	self.findmode=False
        self.parenttable = parenttable
        self.parentfield = parentfield
        self.mylinkfield = mylinkfield
        # don't show the pkey but show the line number
        self.pkeyhelper = []
	if self.xml:
	    if self.xml.getprop("primary"):
		self.primary=self.xml.getprop("primary")
	    else:
		d = self.tabledata[0][3]
		self.primary = self.tabledata[int(string.replace(string.replace(d,"{",""),"}",""))-1][0]
	else:
	    d = self.tabledata[0][3]
	    self.primary = self.tabledata[int(string.replace(string.replace(d,"{",""),"}",""))-1][0]
        self.fieldnames=[]
        i=0
        for field in self.tabledata:
            if field[0]<>self.mylinkfield:
                self.fieldnames.append(field[0])
                if field[0]<>self.primary:
                    self.grid.SetColLabelValue(i,field[0])
                    i+=1
        for a in self.addcolums:
            self.grid.SetColLabelValue(i,str(a))
	    #if self.xml:
	    #	if self.xml.getname()[:7]=="dportal":
	    #	    self.fieldnames.append(str(a))
            i+=1
	if self.title:
	    self.original_title=self.grid.GetColLabelValue(0)
	    self.grid.SetColLabelValue(0,self.title)
    def OnClick(self,event):
	col= event.GetCol()
        row= event.GetRow()
	if self.busy:
            event.Skip()
            return
	field = self.grid.GetColLabelValue(col)
	if field in self.overlaydic.keys():
	    field=self.overlaydic[field]
	if field==self.title:field=self.original_title
	if self.enum.has_key(field):
	    # This is an enum, display a choicedialog
	    choices = self.enum[field]
	    nchoices = []
	    for c in choices:nchoices.append(c)
	    if self.findmode:nchoices.append("NOT NULL")
	    dialog = wx.SingleChoiceDialog(self.parent,_("Choose a value"),field,nchoices)
	    result = dialog.ShowModal()
	    if result==wx.ID_OK:
		value = dialog.GetStringSelection()
		self.grid.SetCellValue(row,col,value)
		self.update(event)
	else:
	    event.Skip()
    def GetGrid(self):
	if self.staticsizer==False:
	    return self.grid
	else:
	    return self.sizer
    def delete(self,event):
	print "DELETE?DUP PORTAL ROW"
        if self.parent.mode<>"browse":
	    event.Skip()
            return
        if self.busy:
            event.Skip()
            return
        row= event.GetRow()
	if row<0:
	    event.Skip()
	    return
        pkey = self.grid.GetRowLabelValue(row)
	print row,pkey
        if pkey<>"...":
	    event.Skip()
	    if event.ControlDown():
		# Duplicaat
		pkey = self.pkeyhelper[int(pkey)-1]
		w = wx.MessageBox(_("Duplicate this sub record ?"),_("warning"),style = wx.OK | wx.CANCEL )
		if w==wx.OK:
		    t = copy.copy(self.fieldnames)
		    t.remove(self.primary)
		    t.append(self.mylinkfield)
		    fnames = ",".join(t)
		    sql = "insert into %s (%s) select %s from %s where %s=%s;"%(self.table,fnames,fnames,self.table,self.primary,pkey)
		    print sql
		    cursor = self.db.cursor()
		    cursor.execute(sql)
		    if cursor.error:
			self.db.rollback()
			wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
			event.Veto()
		    else:
			self.db.commit()
			self.db.rollback() #  ??
			# TODO, check for triggers and only update the things needed
			self.xml_update()
			self.parent.loadrecord()
	    else:
		pkey = self.pkeyhelper[int(pkey)-1]
		w = wx.MessageBox(_("Delete this sub record ?"),_("warning"),style = wx.OK | wx.CANCEL )
		if w==wx.OK:
		    sql = "delete from %s where %s=%s;"%(self.table,self.primary,pkey)
		    cursor = self.db.cursor()
		    cursor.execute(sql)
		    if cursor.error:
			self.db.rollback()
			wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
			event.Veto()
		    else:
			self.db.commit()
			# TODO, check for triggers and only update the things needed
			self.xml_update()
			self.parent.loadrecord()
	    
    def xml_update(self):
	# check evt_update
	if self.xml:
	    if self.xml.getprop("evt_update"):
		# This is a stupid situation, a database in the field uses this function for script execution,
		# This is a very big bug, we will work around this by checking is the first word is update,insert or delete
		command = self.xml.getprop("evt_update").lower()
		if command[:6] in ("update","insert","delete"):
		    cursor = self.db.cursor()
		    cursor.execute(self.xml.getprop("evt_update").replace("$primary",str(self.parent_key)))
		    if cursor.error:
			self.db.rollback()
			wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
			event.Veto()
		    else:
			self.db.commit()
			# TODO, check for triggers and only update the things needed
			#self.parent.loadrecord()		   
		else:
		    sh = os.popen("%s %s"%(self.xml.getprop("evt_update"),self.parent_key))
		    t = sh.read()
		    if len(t)>0:wx.MessageBox(t,_("External error"),style=wx.OK)
    def update(self,event):
        print "UPDATE"
        if self.parent.mode<>"browse":
            return
        if self.busy:
            event.Skip()
            return
        col= event.GetCol()
        row= event.GetRow()
        value = self.grid.GetCellValue(row,col)
        pkey = self.grid.GetRowLabelValue(row)
        if pkey<>"...":pkey = self.pkeyhelper[int(pkey)-1]
        field = self.grid.GetColLabelValue(col)
	if field in self.overlaydic.keys():
	    field=self.overlaydic[field]
	if field==self.title:field=self.original_title
        if field not in self.fieldnames:
	    print "field %s not in %s"%(field,self.fieldnames)
	    print self.overlaydic
            event.Veto()
            return
        if pkey=="...":
            if value=="":return
	    if self.where=="":
		sql = "insert into %s (%s,%s) values ('%s','%s');"%(self.table,self.mylinkfield,field,self.parent_key,S(value))
	    else:
		wfields = self.where.split("=")
		sql = "insert into %s (%s,%s,%s) values ('%s','%s',%s);"%(self.table,self.mylinkfield,field,wfields[0],self.parent_key,S(value),wfields[1])

	    print sql
            cursor = self.db.cursor()
            cursor.execute(sql)
            if cursor.error:
		self.db.rollback()
                wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
                event.Veto()
            else:
                self.db.commit()
                # TODO, check for triggers and only update the things needed
		self.xml_update()
		self.parent.loadrecord()

        else:
	    # change ?! was "...field in self.enum.keys() and..."
	    if value=="":
		sql = "update %s set %s=null where %s=%s;"%(self.table,field,self.primary,pkey)
	    else:
		sql = "update %s set %s='%s' where %s=%s;"%(self.table,field,S(value),self.primary,pkey)
            cursor = self.db.cursor()
            cursor.execute(sql)

            if cursor.error:
		self.db.rollback()
                wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
                event.Veto()
            else:
                self.db.commit()
                # TODO, check for triggers and only update the things needed
		self.xml_update()
                self.parent.loadrecord()
		
            # probably reload this data to make sure it's ok
	
    def find_mode(self,bool=True):
        # clear content
	self.findmode=bool
	self.busy=True
        self.parent_key=None
        if self.grid.GetNumberRows()>0:self.grid.DeleteRows(0,self.grid.GetNumberRows())
        self.grid.AppendRows()
        self.grid.SetRowLabelValue(0,"?")
	self.busy=False
    def getfind(self):
        # check if someone entered data in the portal in find mode
        sql=""
        fs="where"
        for c in range(self.grid.GetNumberCols()):
            if self.grid.GetCellValue(0,c)<>"":
                fieldname = self.fieldnames[c+1]
                field = None
                for f in self.tabledata:
                    if f[0]==fieldname:field=f
                type = field[1]
                value = self.grid.GetCellValue(0,c)
                operator = "="
                if value[0] in ("=","<",">"):
                    operator = value[0]
                    value = value[1:]
                elif value[:2] in ("<=",">=","<>","!="):
                    operator = value[:2]
                    value = value[2:]
                elif string.find(value,"...")>-1:
                    operator = "range"
                    value = string.split(value,"...")
                elif type in ("char","varchar","text"):
                    operator = "~*"
                elif type == "bool":
                    operator = "bool"
                if type not in ('int4','int','int8','numeric','float','numeric') and value<>"NOT NULL":
                    if operator<>"range":
                        value = "'%s'"%value
                    else:
                        nv=[]
                        for v in value:nv.append("'%s'"%v)
                        value=nv
		if value=="NOT NULL":
		    sql+= "%s not %s ISNULL "%(fs,fieldname)
                elif operator=="range":
                    sql += " %s ( %s >= %s and %s<=%s) "%(fs,fieldname,value[0],fieldname,value[1])
                elif operator=="bool":
                    if value == "t":
                        sql+= " %s %s='t' "%(fs,fieldname)
                else:
                    sql+= " %s %s %s %s"%(fs,fieldname,operator,value)
                fs = "and"
        if sql=="":
            return None
        else:
	    w=""
	    if self.where<>"":
		w=" and %s"%self.where
            rsql = "%s in (select %s from %s %s %s)"%(self.parentfield[0],self.mylinkfield,self.table,sql,w)
            return rsql


    def load(self,pkey):
        """ Load new data from the db with the parent it's new key"""
        self.busy=True
        self.pkeyhelper = []
        self.parent_key=pkey # this wrongly assumes the parent pkey is the right field
        cursor = self.db.cursor()
	if self.xml:
	    if self.xml.getprop("parent_field"):
		if str(self.xml.getprop("parent_field"))<>str(self.parent_primary):
		    print ("select %s from %s where %s=%s"%(self.parentfield[0],self.parenttable,self.parent_primary,pkey))
		    cursor.execute("select %s from %s where %s=%s"%(self.parentfield[0],self.parenttable,self.parent_primary,pkey))
		    d = cursor.fetchall()
		    self.parent_key = d[0][0]
	o = ""
	if self.where<>"":o=" and %s"%self.where
        sql = "select %s from %s where %s=(select %s from %s where %s=%s) %s order by %s;"%(string.join(self.fieldnames,","),self.table,self.mylinkfield,self.parentfield[0],self.parenttable,self.parent_primary,pkey,o,self.primary)
	print sql
        cursor.execute(sql)
	if cursor.error:
	    self.db.rollback()
	    wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
	    self.busy=False
	    return
        data = cursor.fetchall()
        self.data=[]
        for d in data:
            dum=[]
            for dd in d:
                dum.append(dd)
            self.data.append(dum)
        if self.grid.GetNumberRows()<(len(self.data)+1):
            self.grid.AppendRows((len(self.data)+1)-self.grid.GetNumberRows())
        elif self.grid.GetNumberRows()>(len(self.data)+1):
            self.grid.DeleteRows(0,self.grid.GetNumberRows()-(len(self.data)+1))
        self.grid.ClearGrid()
        i=0
        for d in self.data:
            q=0
            self.pkeyhelper.append(d[0])
            self.grid.SetRowLabelValue(i,str(i+1))
            for od in d[1:]:
                if od<>None:self.grid.SetCellValue(i,q,str(od))
                q+=1
            p=0
            for a in self.addcolums:
                cursor =self.db.cursor()
                cursor.execute(string.replace(self.sqladd[p],"$primary",str(d[0])))
                data = cursor.fetchall()
                if len(data)==1:
                    if data[0][0]<>None:self.grid.SetCellValue(i,q,str(data[0][0]))
                p+=1
                q+=1
            i+=1
        # add a row, place ... in the label
        self.grid.SetRowLabelValue(i,"...")
	# overlaysql
	self.overlaydic={}
	if self.overlaysql<>None:
	    
	    cursor.execute(self.overlaysql.replace("$primary",str(pkey)))
	    if cursor.error:
		self.db.rollback()
		wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
		self.busy=False
		return
	    odata = cursor.fetchall()
	    print odata
	    if len(odata)==1:
		overlay = odata[0][0].split("$$")
		print self.fieldnames
	        print overlay
		if len(overlay)==(len(self.fieldnames)-len(self.addcolums)):
		    for i in range(len(self.fieldnames)-len(self.addcolums)):
			self.overlaydic[overlay[i]]=self.fieldnames[i+1]
			self.grid.SetColLabelValue(i,overlay[i])
	    
        self.busy=False
class xmlfonthelper:
    def __init__(self,currentfont):
	# currentfotn for standard is overrun for now, does not work on mac, works only sometimes on linux
	# 12 point good default ?
        self.standard = wx.Font(12,wx.FONTFAMILY_DEFAULT,wx.FONTSTYLE_NORMAL,wx.FONTWEIGHT_NORMAL)
        if 9==0:self.standard=wx.Font()
        self.std_size = 12 #self.standard.GetPointSize()
        # 
    def getfont(self,xml):
        if xml==None:
            return self.standard
        if xml.getprop("bold") or xml.getprop("underline") or xml.getprop("size"):
            size = self.std_size
            family = wx.FONTFAMILY_DEFAULT
            style = wx.FONTSTYLE_NORMAL
            weight = wx.FONTWEIGHT_NORMAL
            underline=False
            if xml.getprop("size"):size=int(xml.getprop("size"))
            if xml.getprop("bold")=="True":weight=wx.FONTWEIGHT_BOLD
            if xml.getprop("underline")=="True":underline=True
            return wx.Font(size,family,style,weight,underline)
        else:
            return self.standard
class DummySort:
    def __init__(self):
	pass
class SortDialog:
    def __init__(self,parent,afields):
        res = xrc.XmlResource("ui%sxrc%ssortwindow.xrc"%(os.sep,os.sep))
        self.dialog = res.LoadDialog(parent,"sort_dialog")
        self.afields = afields
        self.list_fields = xrc.XRCCTRL(self.dialog,"list_fields")
        self.list_sort = xrc.XRCCTRL(self.dialog,"list_sort")
        self.btn_add = xrc.XRCCTRL(self.dialog,"btn_add")
        self.btn_del = xrc.XRCCTRL(self.dialog,"btn_del")
        self.btn_up = xrc.XRCCTRL(self.dialog,"btn_up")
        self.btn_down = xrc.XRCCTRL(self.dialog,"btn_down")
        self.btn_switch = xrc.XRCCTRL(self.dialog,"btn_switch")
        self.btn_close = xrc.XRCCTRL(self.dialog,"btn_close")
        self.btn_sort = xrc.XRCCTRL(self.dialog,"btn_sort")
        self.status=False
        self.list=[]
        self.desc=[]
        if 8==9:
            self.list_fields=wx.ListBox()
            self.list_sort=wx.ListBox()
        self.load()
        self.btn_close.Bind(wx.EVT_BUTTON,self.oclose)
        self.btn_add.Bind(wx.EVT_BUTTON,self.add)
        self.btn_del.Bind(wx.EVT_BUTTON,self.delete)
        self.btn_up.Bind(wx.EVT_BUTTON,self.up)
        self.btn_down.Bind(wx.EVT_BUTTON,self.down)
        self.btn_switch.Bind(wx.EVT_BUTTON,self.switch)
        self.btn_sort.Bind(wx.EVT_BUTTON,self.sort)
        self.list_fields.Bind(wx.EVT_LISTBOX_DCLICK,self.add)
        self.list_sort.Bind(wx.EVT_LISTBOX_DCLICK,self.switch)
        self.dialog.ShowModal()
    def sort(self,event):
        self.status="OK"
        self.dialog.MakeModal(False)
        self.dialog.Close()
    def switch(self,event):
        s = self.list_sort.GetStringSelection()
        s = s[:len(self.list_sort.GetStringSelection())-6]
        if s in self.list:
            if s in self.desc:
                self.desc.remove(s)
            else:
                self.desc.append(s)
        self.load()
    def load(self):
        i=0 ; q=0
        self.list_fields.Clear()
        self.list_sort.Clear()
        for a in self.afields:
                self.list_fields.Insert(a,i)
                i+=1
        i=0
        for a in self.list:
            vis = ".oO"
            if a in self.desc:vis="Oo."
            self.list_sort.Insert("%s (%s)"%(a,vis),i)
            i+=1
    def down(self,event):
        s = self.list_sort.GetStringSelection()
        s = s[:len(self.list_sort.GetStringSelection())-6]
        if s in self.list:
            i = 0 ; no =-1
            for l in self.list:
                if s==l:no=i
                i+=1
            self.list.remove(s)
            self.list.insert(no+1,s)
        self.load()
    def up(self,event):
        s = self.list_sort.GetStringSelection()
        s = s[:len(self.list_sort.GetStringSelection())-6]
        if s in self.list:
            i = 0 ; no =-1
            for l in self.list:
                if s==l:no=i
                i+=1
            self.list.remove(s)
            self.list.insert(max(no-1,0),s)
        self.load()
    def add(self,event):
        s = self.list_fields.GetStringSelection()
        if s in self.afields:
            self.afields.remove(s)
            self.list.append(s)
        self.load()
    def delete(self,event):
        s = self.list_sort.GetStringSelection()
        s = s[:len(self.list_sort.GetStringSelection())-6]
        if s in self.list:
            self.list.remove(s)
            self.afields.append(s)
        self.load() 
    def oclose(self,event):
        self.dialog.MakeModal(False)
        self.dialog.Close()
     
class Listview(wx.Frame):
    def __init__(self,parent,fieldnames,data,datalist,total=None,current=None):
	""" This is kind of a list on which all records show"""
	wx.Frame.__init__(self,parent,wx.NewId(),"List")
	self.parent=parent
	self.fieldnames=fieldnames
	self.list = wx.ListCtrl(self,wx.NewId(),style=wx.LC_REPORT | wx.LC_SINGLE_SEL)
	i=0
	for f in fieldnames:
	    self.list.InsertColumn(i,f)
	    i+=1
	self.data = data # dictionary with {pkey:[field1,field2]}
	self.datalist = datalist
	i=0
	for d in self.datalist:
	    t=0
	    for field in self.data[d]:
		if t==0:
		    i+=1
		    i = self.list.InsertStringItem(i,str(field))
		else:
		    self.list.SetStringItem(i,t,str(field))
		t+=1
	self.total=total
	if self.total<>None:
	    print self.total
	    i+=1
	    i = self.list.InsertStringItem(i,_("Total"))
	    for tot in self.total:
		# loop data and sum up
		thistotal=0.0
		for d in self.data.keys():
			if self.data[d][tot]<>None:thistotal+=self.data[d][tot]
		    
		self.list.SetStringItem(i,tot,str(round(thistotal,4)))
	    self.list.SetItemBackgroundColour(i,"#85c4ff")
	self.Bind(wx.EVT_SIZE,self.OnSize)
	self.list.Bind(wx.EVT_LIST_ITEM_SELECTED,self.OnClick)
	i=0
	if current:
	    for listkey in self.datalist:
		if current==listkey:
		    self.list.Select(i)
		i+=1
	self.cmenu = wx.Menu()
	if PDF:
	    self.cmenu.Append(-1,"PDF...")
	self.list.Bind(wx.EVT_RIGHT_DOWN,self.ShowPopup)
	self.Bind(wx.EVT_MENU,self.PopSelected)
	self.Show()
    def createpdf(self,path):
	# collect data
	tbl = drawtable(size=(reportlab.lib.pagesizes.A4[1],reportlab.lib.pagesizes.A4[0]-25),path=path)
	#tbl.SetTitle(self.title,box=1)
	#if self.lpcolw: tbl.SetColWidths(self.lpcolw)
	dal={}
	for ii in range(self.list.GetColumnCount()):
	    dal['grid_%s'%ii]=reportlab.lib.colors.burlywood
	tbl.AddDataRow(self.fieldnames,dal)
	for i in range(self.list.GetItemCount()):
	    dum=[]

	    for ii in range(self.list.GetColumnCount()):
		item = self.list.GetItem(i,ii)
		dum.append(item.GetText())
	    
	    if self.list.GetItem(i,0).GetText()=="Subtotaal:":
		q = {}
		for iii in range(self.GetColumnCount()):
		    q['grid_%s'%iii]=reportlab.lib.colors.lemonchiffon
		tbl.AddDataRow(dum,q)
	    elif self.list.GetItem(i,0).GetText()==_("Total"):
		z = {}
		for iii in range(self.GetColumnCount()):
		    z['grid_%s'%iii]=reportlab.lib.colors.lightblue
		tbl.AddDataRow(dum,z)
		
	    else:
		tbl.AddDataRow(dum)
	tbl.draw()
	tbl.save()

    def PopSelected(self,event):
	item = self.cmenu.FindItemById(event.GetId())
	if item<>None:
	    command = item.GetText()
	    
	    if command=="PDF...":
		# ok now
		print "creating pdf"
		f = wx.FileDialog(self,_("Save"),style=wx.SAVE)
		f.ShowModal()
		name = f.GetPath()
		print "-----%s"%name
		self.createpdf(name)
    def ShowPopup(self,event):
	pos = event.GetPosition()
	self.PopupMenu(self.cmenu,pos=pos)
    def RemoveOne(self,key):
	# Find the position of this key, then remove the row
	i=0
	for listkey in self.datalist:
	    if key==listkey:
		self.list.DeleteItem(i)
	    i+=1
	self.datalist.remove(key)
	z= self.data.pop(key)
	# Change totals
	if self.total<>None:
	    i=len(self.datalist)
	    for tot in self.total:
		# loop data and sum up
		thistotal=0.0
		for d in self.data.keys():
		    thistotal+=self.data[d][tot]
		self.list.SetStringItem(i,tot,str(round(thistotal,4)))
	
    def ReloadOne(self,key,data):
	# Find the position of this key, then replace the data
	i=0
	for listkey in self.datalist:
	    if key==listkey:
		# This is the one
		self.data[key]=data
		col=0
		for field in data:
		    self.list.SetStringItem(i,col,str(field))
		    col+=1
		self.list.Select(i)
	    i+=1
	# Change totals
	if self.total<>None:
	    i=len(self.datalist)
	    for tot in self.total:
		# loop data and sum up
		thistotal=0.0
		for d in self.data.keys():
		    thistotal+=self.data[d][tot]
		self.list.SetStringItem(i,tot,str(round(thistotal,4)))
	
    def OnClick(self,event):
	# Jump to key
	print "Jump"
	self.parent.JumpTo(self.datalist[event.GetIndex()])
	event.Skip()
    def OnSize(self,event):
	w = self.GetSize()[0]
	colw = w/self.list.GetColumnCount()
	for c in range(self.list.GetColumnCount()):
	    self.list.SetColumnWidth(c,colw)
	event.Skip()
class button(wx.Button):
    def __init__(self,parent,name):
	wx.Button.__init__(self,parent,wx.NewId(),name,style=wx.BU_EXACTFIT)
class drawtable:
  def __init__(self,size=None,path="/tmp/test.pdf"):
    if size==None:size=reportlab.lib.pagesizes.A4
    self.c = canvas.Canvas(path)
    self.c.setPageSize(size)
    self.title = None
    self.box=None
    self.data = []
    self.datalooks = {}
    self.cw = None
    self.size = size
    self.colheight=16
    self.pagebreaks = []
  def SetColHeight(self,height):
    self.colheight=height
  def SetTitle(self,title,box=None):
    self.title=title
    self.box = box
  def AddDataRow(self,data,looks={}):
    self.data.append([data,looks])
  def PageBreak(self):
    self.pagebreaks.append(len(self.data)-1)
  def SetRowLooks(self,dict):
    self.datalooks = dict
  def SetColWidths(self,widths):
    self.cw = [];total=0.0
    for w in widths:total+=float(w)
    for w in widths:
        print int((w/total)*(self.size[0]*.95))
        self.cw.append(int((w/total)*(self.size[0]*.95)))
        

  def draw(self):
    if self.box<>None:
      self.c.setFillColor(reportlab.lib.colors.aliceblue)
      self.c.rect(int(self.size[0]*.1),int(self.size[1]*0.94),int(self.size[0]*0.8),int(self.size[1]*0.04),fill=1)
    self.c.setFillColor(reportlab.lib.colors.black)
    self.c.setStrokeColor(reportlab.lib.colors.black)
    print self.size
    if self.title:
      if len(self.title)<(self.size[0]/17):
          self.c.setFont('Helvetica',int(self.size[1]*0.04))
      else:
          self.c.setFont('Helvetica',14)
      self.c.drawCentredString(int(self.size[0]*.5),int(self.size[1]*0.95),self.title)
      # so far title part
      offsety = int(self.size[1]*0.93)
    else:
      offsety = int(self.size[1]*0.98)
    colheight = self.colheight
    self.c.setFont('Helvetica',colheight-2)
    datacounter=0
    for d in self.data:
        print d
        actualdata = d[0]
        looks = d[1]
        print looks
        offsetx = int(self.size[0]*.027)
        offsety -=colheight
        aci = 0
        print
        for ac in actualdata:
            ac = str(ac)
            dfill=0
            if looks.has_key('grid_%s'%aci):
                dfill=1
                if looks['grid_%s'%aci]<>1:
                    self.c.setFillColor(looks['grid_%s'%aci])
                else:
                    self.c.setFillColor(reportlab.lib.colors.white)
                if self.cw<>None:
                    self.c.rect(offsetx,offsety,self.cw[aci],colheight,fill=dfill)
                else:
                    self.c.rect(offsetx,offsety,int((self.size[0]*.95)/len(actualdata)),colheight,fill=dfill)
            self.c.setFillColor(reportlab.lib.colors.black)
            if len(ac)>0:
                acwidth = self.c.stringWidth(ac,'Helvetica',colheight-2)
            else:
                acwidth=0
            if self.cw<>None:
                curcw= self.cw[aci]
            else:
                curcw= int((self.size[0]*.95)/len(actualdata))
            if 1:  #acwidth<curcw:
                self.c.drawString(offsetx+2,(offsety+1),ac)
            else:
                pass
                # todo work out a multiline system wich looks nice !!
                #words = string.split(ac)
                #nl=''
                #for w in words:
                #    if self.c.stringWidth(nl,'Helvetica',colheight-2)<curcw:
                #        nl += words.pop() + ' '
            offsetx+=curcw
            aci += 1
        if offsety<colheight+50 or datacounter in self.pagebreaks:
            self.c.showPage()
            offsety = int(self.size[1]*0.98)
        datacounter+=1
            
    
  def save(self):
    #self.c.showPage()
    self.c.save()	
