# general postgres table browser
# 'form' view
# bytea info, when using these fields we check by *magic/mime* if it is a jpeg or something otherwise we present a file icon and you can download it
""" wxpypg, A universal record browser for mac,linux and windows

    LICENSE
    =======

    Copyright (c) 2008, Bram Van Steenlandt
    All rights reserved.

    Redistribution and use in source and binary forms, with or without 
    modification, are permitted provided that the following conditions are met:

        * Redistributions of source code must retain the above copyright 
          notice, this list of conditions and the following disclaimer.
        * Redistributions in binary form must reproduce the above copyright 
          notice, this list of conditions and the following disclaimer in the 
          documentation and/or other materials provided with the distribution.
        * Neither the name of the <ORGANIZATION> nor the names of its 
          contributors may be used to endorse or promote products derived from 
          this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
    POSSIBILITY OF SUCH DAMAGE.

    NOTES
    =======
    This is alpha software.  Don't use it on valuable data.
    Parts of this software are based on Randall Smith his pure python postgresql software

"""
VERSION="0.41"
import os,sys
import string
path = os.path.split(os.getcwd())
parent_path = string.join(path[:len(path)-1],os.sep)
sys.path.insert(0,parent_path)
import db
import wx
import wx.lib.masked as masked
import string
import helpers
import printhelp
import templates
from helpers import S as S
from helpers import _ as _
from helpers import sxml
from helpers import KNOWN_TYPES
import math
_ = wx.GetTranslation
from user import home

class importwindow(wx.Dialog):
    def __init__(self,parent,fields):
        """ this helps in importing records from a file, you should be able to choose the record,field separator """
        wx.Dialog.__init__(self,parent,wx.NewId(),_("Import records"),style=wx.RESIZE_BORDER | wx.CLOSE_BOX)
        self.parent = parent
        self.recordseparator = "10"
        self.fieldseparator = "9"
        self.vsizer = wx.BoxSizer(wx.VERTICAL)
        self.recordseparatortext = wx.StaticText(self,wx.NewId(),_("Record Separator"))
        self.vsizer.Add(self.recordseparatortext)
        self.recordseparatorfield = wx.TextCtrl(self,wx.NewId(),self.recordseparator)
        self.recordseparatorfield.Bind(wx.EVT_KEY_UP,self.dopreview)
        self.vsizer.Add(self.recordseparatorfield)
        self.fieldseparatortext = wx.StaticText(self,wx.NewId(),_("Field Separator"))
        self.vsizer.Add(self.fieldseparatortext)
        self.fieldseparatorfield = wx.TextCtrl(self,wx.NewId(),self.fieldseparator)
        self.fieldseparatorfield.Bind(wx.EVT_KEY_UP,self.dopreview)
        self.vsizer.Add(self.fieldseparatorfield)
        self.previewlist = wx.ListCtrl(self,wx.NewId(),style=wx.LC_REPORT,size=(500,300))
        self.vsizer.Add(self.previewlist,wx.EXPAND)
        i=0
        for f in fields:
            self.previewlist.InsertColumn(i,str(f))
            i+=1
        self.okbut = wx.Button(self,wx.NewId(),_("Import"))
        self.okbut.Bind(wx.EVT_BUTTON,self.doimport)
        self.vsizer.Add(self.okbut)
        self.SetSizerAndFit(self.vsizer)
        
        w = wx.FileDialog(self,_("Choose File"),home,wildcard="*.*",style=wx.OPEN | wx.FILE_MUST_EXIST)
        if w.ShowModal() == wx.ID_OK:
            self.inputfile = file(w.GetPath())
            dummy  = self.inputfile.read()
            self.data = ""
            for dum in dummy:
                if (ord(dum)<>128 and ord(dum)>=32) or ord(dum) in (9,10,13):self.data+=dum
        else:
            self.MakeModal(False)
            self.Close()
            return
        self.list=[]
        self.dopreview()
        self.ShowModal()
    def doimport(self,event):
        self.MakeModal(False)
        if len(self.list)>0:
            self.parent.DoImport(self.list)
        self.Close()
        
    def dopreview(self,event=None):
        # Addition, we should ask the user the encoding we should use
        enc_dialog = wx.SingleChoiceDialog(self,_("Please enter the file encoding (utf-8,Mac-Roman)"),"encoding",["utf-8","Mac-Roman"],style=wx.OK)
        enc_dialog.ShowModal()
        enc = enc_dialog.GetStringSelection()
        if self.previewlist.GetItemCount()>0:self.previewlist.DeleteAllItems()
        self.list = []
        # 2 dimensional
        self.recordseparator = self.recordseparatorfield.GetValue()
        self.fieldseparator = self.fieldseparatorfield.GetValue()
        try:
            self.recordseparator = chr(int(self.recordseparator))
        except:
            pass
        try:
            self.fieldseparator = chr(int(self.fieldseparator))
        except:
            pass
        print self.data
        records = string.split(self.data,self.recordseparator)
        while "" in records:records.remove("")
        rcount=0
        for record in records:
            dammy=[]
            nf=[]
            dum=""
            for f in record:
                if f==self.fieldseparator:
                    nf.append(dum)
                    dum=""
                else:
                    dum+=f
            nf.append(dum)
            fields = nf
            try: # was utf-8
                fields = unicode(record,enc,"strict").split(self.fieldseparator)
            except:
                wx.MessageBox(_("Data error on record %s, possible encoding problem")%rcount)
                return
            fcount=0
            self.previewlist.InsertStringItem(rcount,"")
            for field in fields:
                if fcount<self.previewlist.GetColumnCount():
                    self.previewlist.SetStringItem(rcount,fcount,field)
                    dammy.append(field)
                fcount+=1
            rcount+=1
            if len(dammy)==len(fields):
                self.list.append(dammy)
        print "List with records is now %s long"%len(self.list)
        
class recordbrowser(wx.Frame,helpers.navwin):
    def __init__(self,parent,table,db):
        """" Important note, saving is done on a field by field base"""
        wx.Frame.__init__(self,parent,wx.NewId(),table) #,style= wx.CAPTION|wx.RESIZE_BORDER|wx.SYSTEM_MENU|wx.CLOSE_BOX|wx.TAB_TRAVERSAL|wx.WANTS_CHARS)
        self.SetBackgroundColour("#eeeeee")
        wx.SetDefaultPyEncoding("iso-8859-15") # this should be polled from the db
        # find the table and check what fields are in it
        self.tabcontrols=[]
        self.fields=[]
        self.tabposition=0
        self.db = db
        #self.db.AddCallback(busy)
        self.table=table
        cursor = self.db.cursor()
        # check if field are hidden
        self.ommitfields=[]
        self.reloaders=[]
        self.xml = None
        xmlpath = os.path.join(wx.StandardPaths_Get().GetUserDataDir(),"templates","%s_view.xml"%table)
        if os.path.exists(xmlpath):
            try:
                self.xml=templates.xmltemplate(xmlpath)
            except:
                wx.MessageBox(_("The xml file could not be loaded"),_("error"),style=wx.OK)
        file_version=None
        self.disabled=[]
        if self.xml:
            for x in self.xml.xmlitems:
                if x.getprop("version"):
                    file_version = int(x.getprop("version"))
        # New !, check if there is a newer file on the database server
        cursor.execute("select version from wxpypg_templates where filename='%s_view.xml'"%table)
        if cursor.error:
            self.db.rollback()
            # No permission ? maybe no such tablename ?
        else:
            data = cursor.fetchall()
            if len(data)==1:
                db_version = int(data[0][0])
                if db_version>file_version or file_version==None:
                    # Fetch new file from db
                    cursor.execute("select data from wxpypg_templates where filename='%s_view.xml'"%table)
                    xmlfiledata = cursor.fetchall()[0][0]
                    ESCAPE_LIST=[]
                    for i in range(256):ESCAPE_LIST.append(i)
                    for i in range(126-32):ESCAPE_LIST.remove(i+32)
                    ESCAPE_LIST.append(39)
                    ESCAPE_LIST.append(92)
                    for E in ESCAPE_LIST:
                        q  = "\\%s"%string.rjust(str(oct(E)),4,"0")[1:]
                        xmlfiledata = string.replace(xmlfiledata,q,chr(E))
                    xmlfiledata = string.replace(xmlfiledata,"\\\\","\\")
                    f = file(xmlpath,"w")
                    f.write(xmlfiledata)
                    f.close()
                    try:
                        self.xml=templates.xmltemplate(xmlpath)
                    except:
                        wx.MessageBox(_("The xml file could not be loaded"),_("error"),style=wx.OK)
        self.position_output=None
        self.current_position=None
        if self.xml:
            for x in self.xml.xmlitems:
                if x.getprop("hide"):
                    self.ommitfields.append(x.getxmlname())
                if x.getname()[:7]=="options":
                    if x.getprop("disabled")<>None:
                        self.disabled=x.getprop("disabled").split(",")
                    if x.getprop("position_output")<>None:
                        self.position_output=x.getprop("position_output")

        # get field names
        cursor.execute(str("select pg_attribute.attname,pg_type.typname,pg_attribute.atttypmod,pg_constraint.conkey,pg_attribute.attrelid from pg_attribute left outer join pg_type on (pg_type.oid = pg_attribute.atttypid) left outer join pg_class on (attrelid= pg_class.oid) left outer join pg_constraint on (pg_constraint.conrelid=pg_class.oid) where pg_class.relname='%s' and attnum>0 and attisdropped='f' and contype='p' order by attnum;"%self.table))
        #cursor.execute(str("select pg_attribute.attname,pg_type.typname,pg_attribute.atttypmod,pg_constraint.conkey,pg_attribute.attrelid from pg_attribute left outer join pg_type on (pg_type.oid = pg_attribute.atttypid) left outer join pg_class on (attrelid= pg_class.oid) left outer join pg_constraint on (pg_constraint.conrelid=pg_class.oid) where pg_class.relname='%s' and attnum>0 and attisdropped='f' order by attnum;"%self.table))
        self.fielddata = cursor.fetchall()
        # find out what the primary key is
        #cursor.execute("select  column_name from information_schema.constraint_column_usage where table_name='%s';"%table)
        #pd = cursor.fetchall()
        #if len(pd)>0:
        #    self.primary = pd[0][0]
        #else:
        #    self.primary = None
        if len(self.fielddata)==0:
            # this usually means the selected table does not exists
            wx.MessageBox(_("Table %s does not exist or has no pkey ?"%self.table),_("error"),style=wx.OK)
            return
        if self.fielddata[0][3]<>"" and self.fielddata[0][3]<>None:
            p = self.fielddata[0][3]
            p = string.replace(string.replace(p,"{",""),"}","")
            if string.find(p,",")>-1:
                wx.MessageBox(_("No support for multiple primary keys yet"),_("error"),style=wx.OK)
                wx.Exit()
                return
            self.primary = self.fielddata[int(p)-1][0]
        else:
            self.primary = None
        # 08/03/27 -- add xml support for placement of fields

        # check for the existance of child tables, table wich are constraint by this table
        # show them as a portal in a listbox
        tableid = self.fielddata[0][4]
        cursor.execute("select conrelid,confkey,conkey from pg_constraint where contype='f' and confrelid=%s;"%tableid)
        childdata = cursor.fetchall()
        self.portals=[]
        for child in childdata:
            # there are child tables, this is tricky,
            cursor.execute("select pg_attribute.attname,pg_type.typname,pg_attribute.atttypmod,pg_constraint.conkey,pg_attribute.attrelid,pg_class.relname from pg_attribute left outer join pg_type on (pg_type.oid = pg_attribute.atttypid) left outer join pg_class on (attrelid= pg_class.oid) left outer join pg_constraint on (pg_constraint.conrelid=pg_class.oid) where pg_attribute.attrelid=%s  and attnum>0 and attisdropped='f' and contype='p' order by attnum;"%child[0])
            cdata = cursor.fetchall()
            child_2 = int(string.replace(string.replace(child[1],"{",""),"}",""))
            child_3 = int(string.replace(string.replace(child[2],"{",""),"}",""))
            xml = None
            if self.xml<>None:
                xml = self.xml.item("portal_%s"%cdata[0][5])
            self.portals.append(helpers.dbportal(self,cdata[0][5],self.db,cdata,self.table,self.primary,self.fielddata[child_2-1],cdata[child_3-1][0],xml=xml))
        self.vsizer = wx.GridBagSizer(hgap=5,vgap=5)
        c=8
        #self.buttonsizer = wx.BoxSizer(wx.HORIZONTAL)
        self.buildbuttons()
        #self.vsizer.SetCols(2)
        maxxis=0
        self.fields = []
        i=0;span=0;offy=1;maxy=0
        offx=0
        self.fieldnames=[]
        for f in self.fielddata:
            if f[0] not in self.ommitfields:
                xml=None
                if self.xml:
                    xml = self.xml.item("field_%s"%f[0])
                else:
                    xml=None
                posx = offx
                posy = offy
                
                if xml:
                    if xml.getprop("posx") <> None and xml.getprop("posy") <> None:
                        posx=xml.posx()
                        posy=xml.posy()
                        print "Found xml data for %s at %s,%s"%(f[0],posx,posy)
                    else:
                        posy+=span
                else:
                    posy+=span
                if maxxis<posx:maxxis=posx
                self.fieldnames.append(f[0])
                ro = (f[0]==self.primary)
                if f[1]=="bytea":
                    t = helpers.Blobfield(self,self.db,self.table,self.primary,f[0],xml=xml)
                    self.vsizer.Add(t.label,(posy,posx),flag=wx.ALIGN_RIGHT | wx.ALIGN_CENTER_VERTICAL)
                    self.vsizer.Add(t.sizer,(posy,posx+1),(t.span,3))
                    print "Adding bytea on %s %s"%(posy,posx)
                else:
                    enum=False
                    ftype=f[1]
                    if f[1] not in KNOWN_TYPES:
                        # could this be an enum ? let's check
                        print "%s is not in KNOWN_TYPES,ENUM ?"%f[1]
                        cursor.execute("select enumlabel from pg_type left outer join pg_enum on (pg_enum.enumtypid=pg_type.oid) where typname='%s';"%f[1])
                        data = cursor.fetchall()
                        if len(data)>0:
                            enum=[]
                            ftype='enum'
                            for d in data:enum.append(d[0])
                            enum.append("")
                            
                        
    
                    t = helpers.fieldwithlabel(self,f[0],ftype,ro=ro,maxlen=f[2],list=enum,xml=xml)
                    self.vsizer.Add(t.label,(posy,posx),flag=wx.ALIGN_RIGHT | wx.ALIGN_CENTER_VERTICAL)
                    ospan=3
                    if t.GetWidth()<=100:
                        ospan=1
                    
                    self.vsizer.Add(t.field,(posy,posx+1),(t.span,ospan))
                    t.field.Bind(wx.EVT_CHAR,self.chk_tab)
                    t.field.Bind(wx.EVT_KILL_FOCUS,self.savefield)
                    if t.combo:
                        #t.SetCombo(self.savefield)
                        t.field.Bind(wx.EVT_COMBOBOX,self.savefield)
                        if t.reloader:
                            # This field is an sql based combo box and should be able to be refreshed
                            # We are going to reload these on every "Activate"
                            self.reloaders.append(t)
                    if not t.ro:self.tabcontrols.append(t.field)
                self.vsizer.AddGrowableCol(offx+1)
                self.fields.append(t)
                i+=1 ; span+=t.span
                maxy = max(maxy,span+offy)
                if span>=c: # change 30/11/2010 -- == is now >= 
                    offx+=4
                    span=0
            
        c = offx+4
        if span==0:c-=4
        if (maxxis+4)>c:c=maxxis+4
        self.vsizer.Add(self.navbar.sizer,(0,0),(1,c),flag=wx.EXPAND)
        self.vsizer.SetCols(c)
        print "Col num = %s,maxxis= %s"%(c,maxxis)
        # Change, 18/08 - a portal can also be added this way, we will call this an d(efined)portal
        # dportal:
        if self.xml:
            for x in self.xml.xmlitems:
                if x.getname()[:7]=="dportal":
                    self.portals.append(helpers.dbportal(self,x.getprop("table"),self.db,[],self.table,self.primary,[x.getprop("parent_field")],x.getprop("link_field"),xml=x))
                    print self.portals
        # Basicly there support for just one portalsizer for now
        self.portalsizer=[]
        self.portalconditions={}
        if self.xml:
            for x in self.xml.xmlitems:
                if x.getname()[:11]=="portalsizer":
                    self.portalsizer = x.getprop("items").split("$$")
                    if x.getprop("condition"):
                        for p in self.portalsizer:self.portalconditions[str(p)]=x.getprop("condition")
                    self.psizer = wx.BoxSizer(wx.HORIZONTAL)
                    posy = maxy ; posx=0
                    if x.getprop("posy"):posy= int(x.getprop("posy"))
                    self.vsizer.Add(self.psizer,(posy,posx),(5,c))
                    maxy+=5
                    
        for p in self.portals:
            xml = None
            if self.xml<>None:
                xml = self.xml.item("portal_%s"%p.table)
            if xml==None:
                xml = p.xml
            if xml==None:
                posy = maxy ; posx=0
            else:
                if xml.posy()<>None and xml.posx()<>None:
                    posy = xml.posy()
                    posx=xml.posx()
                    print "Found xml data for %s at %s,%s"%(p.table,posx,posy)
                else:
                    posy = maxy ; posx=0
            width = 100
            height=100
            if xml:
                print "yoy"
                print str(xml.getname()[8:]) # or 8: ?
                print self.portalsizer
                if xml.getprop("width"):width=int(xml.getprop("width"))
                if xml.getprop("height"):height=int(xml.getprop("height"))
                if str(xml.getname()[8:]) in self.portalsizer:
                    p.grid.SetInitialSize((width,height))
                    self.psizer.Add(p.GetGrid())
                    self.psizer.Add((2,2))
                    print "yay"
                    print self.portalsizer
                else:
                    p.grid.SetInitialSize((width,100))
                    self.vsizer.Add(p.GetGrid(),(posy,posx),(5,c)) #flag=wx.GROW)
                    self.vsizer.AddGrowableRow(posy)
                    maxy+=5
            else:
                p.grid.SetInitialSize((100,100))
                self.vsizer.Add(p.GetGrid(),(posy,posx),(5,c)) #flag=wx.GROW)
                self.vsizer.AddGrowableRow(posy)
                maxy+=5
        # find other xml items,these
        self.updateables = [] # a list of items wich can be updated
        self.sortfields=[]
        if self.xml:
            for x in self.xml.xmlitems:
                if x.getname()[:4]=="stat":
                    s = helpers.freestatictext(self,wx.NewId(),x.getname()[5:])
                    if x.getprop("color"):
                        s.SetForegroundColour(x.getprop("color"))
                        
                    self.vsizer.Add(s,(x.posy(),x.posx()),(x.spanx(),x.spany()))
                    u = x.getprop("sql")
                    if u:
                        s.sql = u
                        s.dbparent = self
                        self.updateables.append(s)
                elif x.getname()[:6]=="button":
                    b = helpers.button(self,x.getname()[7:])
                    b.command = x.getprop("command")
                    b.arguments = x.getprop("arguments")
                    b.sql = x.getprop("sql")
                    b.find = x.getprop("find")
                    b.Bind(wx.EVT_BUTTON,self.OnCommandButton)
                    self.navbar.sizer.Add(b)
                elif x.getname()[:5]=="start":
                    cursor.execute(x.getprop("sql"))
                    self.db.startsql=x.getprop("sql")
                    self.db.commit()
                    print x.getprop("sql")
                elif x.getname()[:4]=="sort":
                    self.sortfields = x.getprop("fields").split("$$")
                        
        self.currentpkey=None
        self.recordset =[]
        self.bbar = wx.StatusBar(self,wx.NewId())
        self.bbar.SetFieldsCount(2)
        self.bbar.SetStatusWidths([-7,-3])
        self.SetStatusBar(self.bbar)
        self.recordcounter = [0,0]
        self.recordposition=0
        self.afield = None
        self.SetSizerAndFit(self.vsizer)
        self.Bind(wx.EVT_CLOSE,self.oclose)
        self.Bind(wx.EVT_SIZE,self.sizehelp)
        self.list=None
        self.Show()
        self.CenterOnScreen()
        # resize, sometimes it's to small, lets make it 15 pix bigger
        if len(self.portals)>0:
            self.vsizer.SetMinSize((self.vsizer.GetMinSize()[0]+30,self.vsizer.GetMinSize()[1]))
            self.SetSize(self.vsizer.GetMinSize())
        # review tab order, if there is one item in the xml with a tab property then you have to give them all one
        xmltab=False ; td={}
        for f in self.fields:
            if f.xml:
                if f.xml.getprop("taborder"):
                    xmltab=True
                    td[int(f.xml.getprop("taborder"))]=f.xml.getname()
        for p in self.portals:
            if p.xml:
                if p.xml.getprop("taborder"):
                    xmltab=True
                    td[int(p.xml.getprop("taborder"))]=p.xml.getname()
        if xmltab:
            self.tabcontrols=[]
            l = td.keys()
            l.sort()
            for keys in l:
                for f in self.fields:
                   if f.xml:
                       if f.xml.getname()==td[keys]:
                           self.tabcontrols.append(f.field)
                for f in self.portals:
                   if f.xml:
                       if f.xml.getname()==td[keys]:
                           self.tabcontrols.append(f.grid)
            
        rcursor = self.db.cursor()
        self.sortsql=""
        rcursor.wxexecute("select %s from %s order by %s;"%(self.primary,self.table,self.primary),self,db.getdata())
        self.sizehelp(None)
        self.mode="browse"
        self.dbfreeze = False
        keym.base = self
        self.Bind(wx.EVT_ACTIVATE,self.setk)    
    def WritePosition(self):
        if self.currentpkey<>None:
            if self.position_output<>None:
                if self.current_position<>self.currentpkey:
                    try:
                        f = file(self.position_output,"w")
                        f.write(str(self.currentpkey))
                        f.close()
                        self.current_position=self.currentpkey
                        print "Wrote %s"%self.currentpkey
                    except:
                        wx.MessageBox(_("Could not write to position file"),style=wx.OK)
    def OnCommandButton(self,event):
        object = event.GetEventObject()
        command = object.command
        cursor = self.db.cursor()
        if object.sql<>None:
            sql = object.sql
            sql = sql.replace("$primary",str(self.currentpkey))
            cursor.execute(sql)
            self.db.commit()
            self.loadrecord()
        elif object.find<>None:
            sql = object.find.replace("$primary",str(self.currentpkey)) + self.sortsql
            rcursor = self.db.cursor()
            rcursor.wxexecute(sql,self,self.db.getdata())
        else:
            sql = object.arguments
            sql = sql.replace("$primary",str(self.currentpkey))
            sr = []
            for r in self.recordset:sr.append(str(r))
            sql = sql.replace("$keys",",".join(sr))
            cursor.execute(sql)
            data = cursor.fetchall()
            a = ""
            for dd in data:
                for d in dd:a+=' "%s"'%d
            print command + a
            sh = os.popen("%s %s"%(command,a))
            print sh.read()
    def setk(self,event):
        if self.dbfreeze==False:
            keym.base=self
            self.ReloadCombo()
        if event<>None:event.Skip()
    def FreezeInteractions(self,freeze=True):
        self.dbfreeze=freeze
    def ReloadCombo(self):
        if self.currentpkey:
            for r in self.reloaders:
                r.reload()
    def sizehelp(self,event):
        # resize colums of grids
        self.Layout()
        for p in self.portals:
            cw=None
            if p.xml:
                if p.xml.getprop("colwidths"):cw=string.split(p.xml.getprop("colwidths"),",")
            if not cw:
                cw=[]
                for i in range(p.grid.GetNumberCols()):cw.append(1)
            scw = 0
            for c in cw:scw+=int(c)
            tsize = self.GetSize()[0]-p.grid.GetRowLabelSize()-40
            si = self.vsizer.FindItem(p.grid)
            if si==None:
                si = self.vsizer.FindItem(self.psizer)
                if p.xml.getprop("width"):
                    width=int(p.xml.getprop("width"))
                    tsize = width-p.grid.GetRowLabelSize()-40
            pos= si.GetPos()[0]
            self.vsizer.Layout()
            rhl = self.vsizer.GetRowHeights()
            h = 0
            for rh in rhl[pos:pos+si.GetSpan()[0]]:
                h+=rh
            # check if less
            sizersum = 0
            for rh in rhl:sizersum+=rh
            sizersum = sizersum + (self.vsizer.GetVGap()*len(rhl)) +10
            if sizersum>self.GetSize()[1]:
                h = h-sizersum-self.GetSize()[1]
            csize = math.floor(tsize/scw)
            for i in range(p.grid.GetNumberCols()):
                p.grid.SetColSize(i,csize*int(cw[i]))
            width = self.GetSize()[0]-5
            if p.xml:
                if p.xml.getprop("width"):
                    width=int(p.xml.getprop("width"))
                if p.xml.getprop("height"):
                    h=int(p.xml.getprop("height"))
            
            #if si<>None:
            p.grid.SetSize((width,h))
            p.grid.SetInitialSize((width,h))
            if 1==9:grid=helpers.gridlib.Grid()
        self.vsizer.FitInside(self)
        self.vsizer.Layout()
        # grid sizer does not work completely
        if event:event.Skip()
        self.Refresh() # needed on newer versions of wx ? - 19/7/2014
    def OnNavSort(self,event):
        # sorting
        if len(self.sortfields)==0:
            self.FreezeInteractions()
            afields = self.fieldnames + self.ommitfields
            s = helpers.SortDialog(self,afields)
        else:
            s = helpers.DummySort()
            s.status="OK"
            s.list=self.sortfields
            s.desc=[]
        if s.status=="OK":
            
            f=[]
            for l in s.list:
                if l in s.desc:
                    f.append(" %s desc"%l)
                else:
                    f.append(l)
            self.sortsql = "order by %s"%string.join(f,",")
            cursor = self.db.cursor()
            sp=[]
            for r in self.recordset:sp.append(str(r))
            try:
                if self.list<>None:self.list.Close()
            except:
                pass
            cursor.wxexecute("select %s from %s where %s in (%s) %s"%(self.primary,self.table,self.primary,string.join(sp,","),self.sortsql),self,self.db.getdata())
    def OnClose(self,event):
        print "command Q"
        self.Close()
        
    def oclose(self,event):       
        # save the last field
        if self.afield<>None:
            t = wx.Event
            e = wx.FocusEvent(wx.wxEVT_KILL_FOCUS,self.afield.GetId())
            e.SetEventObject(self.afield)
            self.savefield(e)
        if wx.Platform!="__WXMAC__":browsers.remove(self)
        event.Skip()
        
    def UpdateRecordCounter(self,text="slurf %s"%VERSION):
        if self.mode=="browse":
            self.recordcounter=[self.recordposition+1,len(self.recordset)]
            s=""
            if self.sortsql<>"":s=_("(SORTED)")
            self.bbar.SetFields([text,"%s/%s %s"%(self.recordcounter[0],self.recordcounter[1],s)])
            if wx.Platform == "__WXGTK__":
                if len(self.recordset)>1:
                    self.navbar.recordslider.SetMax(len(self.recordset))
                    self.navbar.recordslider.SetValue(self.recordposition+1)
                    self.navbar.ShowSlider(True)
                else:
                    self.navbar.recordslider.SetValue(1)
                    self.navbar.ShowSlider(False)
            
        elif self.mode=="find":
            self.bbar.SetFields(["slurf %s"%VERSION,_("FIND MODE")])
    def OnNavNoHover(self,event):
        self.UpdateRecordCounter()
        event.Skip()
    def OnNavHover(self,event):
        self.UpdateRecordCounter(event.GetEventObject().help)
        event.Skip()
    def OnNavOmmit(self,event):
        if len(self.recordset)>1:
            self.ListRemoveOne()
            self.recordset.remove(self.recordset[self.recordposition])
            if self.recordposition>(len(self.recordset)-1):
                self.recordposition=len(self.recordset)-1
            self.loadrecord()
        else:
            wx.MessageBox(_("Can't ommit last record"),_("error"),style=wx.OK)
    def OnNavExport(self,event):
        w = wx.FileDialog(self,_("Save to File"),home,"export.csv",wildcard="*.csv",style=wx.SAVE)
        if w.ShowModal() == wx.ID_OK:
            outputfile = file(w.GetPath(),"w")
            cursor = self.db.cursor()
            srec=[]
            for r in self.recordset:srec.append(str(r))
            cursor.execute("select %s,%s from %s where %s in (%s);"%(self.primary,string.join(self.fieldnames,","),self.table,self.primary,string.join(srec,",")))
            data = cursor.fetchall()
            # add xml fields
            xml=None
            addsql=None
            if self.xml:
                for x in self.xml.xmlitems:
                    if x.getname()[:6]=="export":
                        xml = x
            if xml:
                    if xml.getprop("addsql"):
                        addsql = xml.getprop("addsql")
            for d in data:
                sd = []
                for id in d[1:]:
                    if id<>None:
                        sd.append(str(id))
                    else:
                        sd.append(str(""))
                if addsql:
                    cursor.execute(string.replace(addsql,"$primary",str(d[0])))
                    adata = cursor.fetchall()
                    for d in adata[0]:
                        if d<>None:
                            sd.append(str(d))
                        else:
                            sd.append("")
                outputfile.write(string.join(sd,chr(9))+"\n")
            outputfile.close()
    def ListClose(self):
        if not (str(self.list).find("DELETED")>-1 or self.list==None):
            self.list.Close()       
    def ListRemoveOne(self):
        if not (str(self.list).find("DELETED")>-1 or self.list==None):
            self.list.RemoveOne(self.currentpkey)
    def ListReloadOne(self):
        # The idea of lit reload is to change the list when the record changes
        # We update just the one row otherwise speed would be very bad
        if not (str(self.list).find("DELETED")>-1 or self.list==None):
            # Only when active
            cursor = self.db.cursor()
            sql = "select %s,%s from %s where %s =%s;"%(self.primary,string.join(self.fieldnames,","),self.table,self.primary,self.currentpkey)
            xmlfields = None
            xsum=None
            xml=None
            if self.xml:
                for x in self.xml.xmlitems:
                    if x.getname()[:4]=="list":
                        xml = x
            if xml:
                    if xml.getprop("fields") and xml.getprop("sql"):
                        sql = xml.getprop("sql").replace("$primary",str(self.currentpkey))
            

            print sql
            cursor.execute(sql)
            tdata = cursor.fetchall()
            self.list.ReloadOne(tdata[0][0],tdata[0][1:])

    def OnNavList(self,event):
        if str(self.list).find("DELETED")>-1 or self.list==None:
            #         rcursor.wxexecute("select %s from %s order by %s;"%(self.primary,self.table,self.primary),self,db.getdata())
            cursor = self.db.cursor()
            srec=[]
            for r in self.recordset:srec.append(str(r))
            sortsql = " order by %s"%self.primary
            if self.sortsql<>"":sortsql=self.sortsql
            sql = "select %s,%s from %s where %s in (%s) %s;"%(self.primary,string.join(self.fieldnames,","),self.table,self.primary,string.join(srec,","),sortsql)
            xmlfields = None
            xsum=None
            xml=None
            if self.xml:
                for x in self.xml.xmlitems:
                    if x.getname()[:4]=="list":
                        xml = x
            if xml:
                    if xml.getprop("fields") and xml.getprop("sql"):
                        sql = xml.getprop("sql").replace("$primary",string.join(srec,",")) + " " 
                        if self.sortsql:
                            sfields = self.sortsql.replace("order by","").replace(" ","").split()
                            sort=True
                            for s in sfields:
                                if not s in xml.getprop("fields"):
                                    sort=False
                            if sort:
                                sql += self.sortsql
                            else:
                                wx.MessageBox(_("List is unsorted,if you want the list to be sorted,sort on columns available in the list."),_("error"),style=wx.OK)
                        xmlfields = xml.getprop("fields").split(",")
                    if xml.getprop("sum"):
                        x = xml.getprop("sum").split(",")
                        xsum = []
                        for xx in x:xsum.append(int(xx))
            

            print sql
            cursor.execute(sql)
            if cursor.error:
                wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
                self.db.rollback()
            tdata = cursor.fetchall()
            data={}
            datalist=[]
            for t in tdata:
                data[t[0]]=t[1:]
                datalist.append(t[0])
            total = None
            tt =[]
            # Check for tot options, this means checking countable fields, for now we sum everything
            q=0
            for fields in self.fieldnames:
                for f in self.fielddata:
                    print f[0],fields,f[1]
                    if f[0]==fields:
                        if f[1] in ('numeric','int4','int8','float'):tt.append(q)
                q+=1                       
            if len(tt)>0 and xmlfields==None:total=tt
            if xsum:total=xsum
            if xmlfields==None:
                lfields = self.fieldnames
            else:
                lfields = xmlfields
            self.list = helpers.Listview(self,lfields,data,datalist,total,self.currentpkey)
        else:
            self.list.Raise()
    def LoadFromCursor(self,cursor,waitwindow):
        self.FreezeInteractions(freeze=False)
        if self.mode=="browse":
            if cursor.error:
                self.db.rollback()
                wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
                return
            rdata = cursor.fetchall()
            self.recordset=[]
            for r in rdata:
                self.recordset.append(r[0])
            self.recordposition=0
            waitwindow.Close()
            waitwindow.Destroy()
            self.tabcontrols[0].SetFocus()
            self.tabcontrols[0].SetInsertionPointEnd()
            self.loadrecord()
        elif self.mode=="find":
            if cursor.error:
                self.db.rollback()
                wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
                return
            data = cursor.fetchall()
            if data==None:
                wx.MessageBox(cursor.errormessage,_("Database error"),style=wx.OK)
            elif len(data)==0:
                wx.MessageBox(_("No records matched your query."),_("Error"),style=wx.OK)
            else:
                # there is data
                for d in data:
                    self.recordset.append(d[0])
            self.recordposition=0
            # goto browse mode
            self.mode="browse"
            self.navbar.find_mode(False)
            for f in self.fields:f.find_mode(False)
            for p in self.portals:p.find_mode(False)
            waitwindow.Close()
            self.tabcontrols[0].SetFocus()
            self.tabcontrols[0].SetInsertionPointEnd()
            self.loadrecord()
    def savefield(self,event):
        if self.currentpkey and len(self.data)>0:
            field = event.GetEventObject().dbparent
            name = field.textlabel
            value = field.GetDbValue()
            typ= field.type
            if typ=='bool':
                if value=='t' and str(self.data[name])=="True":
                    event.Skip()
                    return
                if value=='f' and str(self.data[name])=="False":
                    event.Skip()
                    return
            if typ in ("text","char","varchar","enum") and value<>None and self.data[name]<>None:
                if S(value)==S(self.data[name]):
                    event.Skip()
                    return
            elif value==self.data[name]:
                event.Skip()
                return
            if value==None:
                if str(type(self.currentpkey))=="<type 'str'>":
                    sql = "update %s set %s=null where %s='%s'"%(self.table,name,self.primary,self.currentpkey)
                else:
                    sql = "update %s set %s=null where %s=%s"%(self.table,name,self.primary,self.currentpkey)
            elif typ in ("int8"):
                if str(type(self.currentpkey))=="<type 'str'>":
                    sql = "update %s set %s=%s where %s='%s'"%(self.table,name,value,self.primary,self.currentpkey)
                else:
                    sql = "update %s set %s=%s where %s=%s"%(self.table,name,value,self.primary,self.currentpkey)
            else:
                if str(type(self.currentpkey))=="<type 'str'>":
                    sql = "update %s set %s=E'%s' where %s='%s'"%(self.table,name,S(value),self.primary,self.currentpkey)
                else:
                    sql = "update %s set %s=E'%s' where %s=%s"%(self.table,name,S(value),self.primary,self.currentpkey)
            cursor = self.db.cursor()
            cursor.execute(str(sql))
            if field.f_update():cursor.execute(self.fhelp("%s"%field.f_update()))
            # make except if exception
            if cursor.error:
                self.db.rollback()
                wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
            else:
                self.db.commit()
            for u in self.updateables:u.update()
            self.loadrecord()
        event.Skip()
    def fhelp(self,sql):
        if self.currentpkey<>None:
            sql2= string.replace(sql,"$primary",str(self.currentpkey))
            sr = []
            for r in self.recordset:sr.append(str(r))
            sql2 = sql2.replace("$keys",",".join(sr))
            return sql2
        else:
            return None
    def loadrecord(self):
        if len(self.recordset)>0:
            self.currentpkey=self.recordset[self.recordposition]
            normalfieldnames = []
            i=0
            for f in self.fieldnames:
                if "Blobfield" not in str(self.fields[i]):
                    normalfieldnames.append(f)
                i+=1
            for o in self.ommitfields:normalfieldnames.append(o)
            if str(type(self.currentpkey))=="<type 'str'>":
                sql = "select %s from %s where %s='%s'"%(string.join(normalfieldnames,","),self.table,self.primary,self.currentpkey)
            else:
                sql = "select %s from %s where %s=%s"%(string.join(normalfieldnames,","),self.table,self.primary,self.currentpkey)
            self.data = {}
            cursor = self.db.cursor()
            cursor.execute(str(sql))
            if cursor.error:
                self.db.rollback()
                wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
            
            data = cursor.fetchall()
            if len(data)<>1:
                wx.MessageBox(_("Could not load this record, someone may have deleted it"),_("error"))
                return
            data=data[0]
            i = 0
            for k in normalfieldnames:
                if data[i]==None:
                    self.data[k]=None
                else:
                    self.data[k]=str(data[i])
                i+=1
            for f in self.fields:
                if "Blobfield" in str(f):
                    f.loadfromdb(self.currentpkey)
                else:
                    f.SetVal(self.data[f.name])
        else:
            for f in self.fields:f.SetVal("")
            if self.mode=="browse":
                w = wx.MessageBox(_("No record loaded, data can't be saved"),_("error"),style=wx.OK)


        for p in self.portals:
            p.load(self.currentpkey)
        for u in self.updateables:u.update()
        self.UpdateRecordCounter()
        #self.Update()
        self.Refresh(True)
        self.ListReloadOne()
        self.WritePosition()
        
    def GetFieldType(self,fieldname):
        for f in self.fielddata:
            if f[0]==fieldname:return f[1]
    def GetFieldLen(self,fieldname):
        for f in self.fielddata:
            if f[0]==fieldname:return f[2]
    def DoImport(self,data):
        fields = []
        for f in self.fieldnames:fields.append(f)
        fields.remove(self.primary)
        cursor = self.db.cursor()
        t=0
        for record in data:
            fs=""
            for ti in fields:
                if ti==fields[len(fields)-1]:
                    fs+=ti
                else:
                    fs+=ti+","
            basicsql = "insert into %s (%s) values ("%(self.table,fs)
            i=0
            list=[]
            for field in record:
                type = self.GetFieldType(fields[i])
                leng = self.GetFieldLen(fields[i])
                if type in ("int8"):
                    list.append(str(field))
                else:
                    if type=="varchar" and len(field) > (leng-4):
                        p = field.replace("'","'\\'")[:(leng-4)]
                        list.append("E'%s'"%S(p))
                    else:
                        p = field.replace("'","\\'")
                        list.append("E'%s'"%S(p))
                i+=1
            fs=""
            q=0
            for ti in list:
                if q==len(list)-1:
                    fs+=ti
                else:
                    fs+=ti+","
                q+=1
            basicsql += "%s);"%fs
            print basicsql
            if len(list)==len(fields):
                t+=1
                cursor.execute(basicsql)
                if cursor.error:
                    self.db.rollback()
                    wx.MessageBox(cursor.errormessage[15:],_("Database error on %s")%t,style=wx.OK)
                    wx.MessageBox(_("Import aborted"),_("error"),style=wx.OK)
                    return
        self.db.commit()
        # Do a reload of all records
        if t==0:
            wx.MessageBox(_("No records imported,do note that the number of fields in the table and the file must match"),_("info"),style=wx.OK)
        else:
            wx.MessageBox(_("%s records imported"%t),_("info"),style=wx.OK)
        rcursor = self.db.cursor()
        rcursor.wxexecute("select pkey from %s order by %s;"%(self.table,self.primary),self,self.db.getdata())

    def OnNavDelete(self,event):
        if self.currentpkey<>None:
            w = wx.MessageBox(_("Delete this record ?"),_("warning"),style = wx.OK | wx.CANCEL )
            if w==wx.OK:
                self.ListRemoveOne()
                self.db.rollback()
                cursor = self.db.cursor()
                cursor.execute("delete from %s where %s=%s"%(self.table,self.primary,self.currentpkey))
                if cursor.error:
                    self.db.rollback()
                    wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
                    return
                self.db.commit()
                self.recordset.remove(self.currentpkey)
                if self.recordposition>(len(self.recordset)-1):
                    if self.recordposition>0:
                        self.recordposition-=1
                        self.loadrecord()
                    else:
                        # no more records, we now enter an empty set
                        self.recordset=[]
                        self.currentpkey=None
                        self.recordposition=0
                        self.loadrecord()
                else:
                    self.loadrecord()
        else:
            wx.MessageBox(_("No record to delete."),_("error"),style=wx.OK)
            
    def OnNavImport(self,event):
        fields = []
        for f in self.fieldnames:fields.append(f)
        for o in self.ommitfields:fields.append(o)
        fields.remove(self.primary)
        w = importwindow(self,fields)
    def JumpTo(self,primary):
        if primary in self.recordset:
            i=0
            for r in self.recordset:
                if r==primary:
                    self.recordposition=i
                i+=1
            self.loadrecord()
    def OnNavNext(self,event):
        if self.recordposition<(len(self.recordset)-1):
            self.recordposition+=1
            self.loadrecord()
    def OnNavSlider(self,event):
        self.recordposition = event.GetPosition()-1
        self.loadrecord()
    def OnNavPrev(self,event):
        if self.recordposition>0:
            self.recordposition-=1
            self.loadrecord()
    def OnNavFirst(self,event):
        self.recordposition=0
        self.loadrecord()
    def OnNavLast(self,event):
        self.recordposition=len(self.recordset)-1
        self.loadrecord()
    def OnNavIfind(self,event):
        self.ListClose()
        ff=[]
        limit=None
        flen=3
        refind=None
        if self.xml:
            for x in self.xml.xmlitems:
                if x.getname()[:5]=="field":
                    if x.getprop("find")=="True":
                        for f in self.fielddata:
                            if f[0]==x.getname()[6:]:
                                ff.append(f)
                if x.getname()[:7]=="options":
                    if x.getprop("limit")<>None:
                        limit=int(x.getprop("limit"))
                    if x.getprop("flen")<>None:
                        flen=int(x.getprop("flen"))
                    if x.getprop("refind")<>None:
                        refind=x.getprop("refind")
        if len(ff)==0:
            i=0
            for f in self.fieldnames:
                if "Blobfield" not in str(self.fields[i]):
                    if "bool" not in str(self.fields[i].type):
                        if len(ff)<8:ff.append(self.fielddata[i])
                i+=1
        #if len(ff)==0:ff=self.fielddata[:8]
        w = helpers.Ifindwin(self,self.db,self.table,ff,self.primary,limit,flen=flen)
        if len(w.selectedkeys)>0:
            if w.appendtoselection.GetValue():
                for s in w.selectedkeys:
                    if not s in self.recordset:
                        self.recordset.append(s)
                        self.recordposition=len(self.recordset)-1
            else:
                if refind and len(w.selectedkeys)==1:
                    cursor=self.db.cursor()
                    print (("%s %s;"%(refind,self.sortsql)).replace("$primary",str(w.selectedkeys[0])))
                    cursor.execute(("%s %s;"%(refind,self.sortsql)).replace("$primary",str(w.selectedkeys[0])))
                    data = cursor.fetchall()
                    self.recordset=[]
                    for d in data:
                        self.recordset.append(d[0])
                else:
                    self.recordset=w.selectedkeys
                self.recordposition=0
            self.tabcontrols[0].SetFocus()
            self.tabcontrols[0].SetInsertionPointEnd()
            self.loadrecord()
    def OnNavNew(self,event):
        print "new record"
        self.db.commit()
        cursor = self.db.cursor()
        # when the following does not work, let the user know
        try:
            cursor.execute("select nextval('%s_%s_seq');"%(self.table,self.primary)) # this could be better
            data = cursor.fetchall()[0][0]
        except:
            wx.MessageBox(_("There was an error reading in the next value of the primary key,make sure this user has enough privileges and the primary key is of type serial"),_("error"),style=wx.OK)
            return
        # check for evt_new,some field can be copied,increment etc
        auto={}
        autoval = {}
        if self.xml:
            if self.currentpkey<>None:
                auto = self.xml.searchitems("evt_new")
        for k in auto.keys():
            if self.currentpkey<>None:
                cursor.execute("select %s from %s where %s=%s;"%(k,self.table,self.primary,self.currentpkey))
                d = cursor.fetchall()
                if auto[k]=="copy":
                    if len(d)==1:
                        autoval[k]=d[0][0]
                elif auto[k][0] in ("+","-","*","/"):
                    oldval = int(d[0][0])
                    newval = eval("%s%s"%(oldval,auto[k]))
                    autoval[k]=str(newval)
        afields = []
        avalues = []
        for a in autoval.keys():
            if a<>self.primary and autoval[a]<>None:
                afields.append(a)
                avalues.append(str(autoval[a]).replace("'","\\'"))
        if len(autoval.keys())==0:
            cursor.execute("insert into %s (%s) values (%s);"%(self.table,self.primary,data))
        else:
            print afields
            print avalues
            cursor.execute("insert into %s (%s,%s) values (%s,'%s');"%(self.table,self.primary,string.join(afields,","),data,string.join(avalues,"','")))
        if cursor.error:
            self.db.rollback()
            wx.MessageBox(cursor.errormessage[15:],_("Database error"),style=wx.OK)
            return False
        else:
            self.db.commit()
        self.recordset.append(data)
        self.recordposition = len(self.recordset)-1
        self.loadrecord()
        # set focus to first field for fast input
        self.tabcontrols[0].SetFocus()
        self.tabcontrols[0].SetInsertionPointEnd()
    def OnNavFind(self,event):
        # enter find mode of go back to browse mode
        if self.mode=="browse":
            self.ListClose()
            self.db.commit()
            self.mode="find"
            self.currentpkey=None
            # disable navbar except find
            self.navbar.find_mode()
            # clear fields
            for f in self.fields:f.find_mode()
            # erase portals
            for p in self.portals:p.find_mode()
            # stats
            for u in self.updateables:u.SetLabel("")
            self.recordset=[]
            self.UpdateRecordCounter()
            self.tabcontrols[0].SetFocus()
            self.tabcontrols[0].SetInsertionPointEnd()
        else:
            # user has entered data ?
            # TODO, get data from portal ?
            # now check for operators, operators are:
            # > greater
            # smaller <
            # greater or equal >=
            # smaller or equal <=
            # range ..
            # exact match =
            sql = "select %s from %s "%(self.primary,self.table)
            fs="where"
            for f in self.fields:
                
                if f.GetDbValue() not in (None,""):
                    value = S(f.GetDbValue())
                    name = f.name
                    operator = "="
                    if value[0] in ("=","<",">"):
                        operator = value[0]
                        value = value[1:]
                    elif value[:2] in ("<=",">=","<>","!="):
                        operator = value[:2]
                        value = value[2:]
                    elif string.find(value,"...")>-1:
                        operator = "range"
                        value = string.split(value,"...")
                    elif string.find(value,",")>-1 and f.type in ('int4','int','int8','numeric','float','numeric'):
                        operator = "in"
                        value = " (%s)"%value
                    elif f.type in ("char","varchar","text") and not f.combo:
                        operator = "~*"
                    elif f.type == "bool":
                        operator = "bool"
                    if f.type not in ('int4','int','int8','numeric','float','numeric','bool'):
                        if operator<>"range":
                            value = "E'%s'"%value
                        else:
                            nv=[]
                            for v in value:nv.append("E'%s'"%v)
                            value=nv
                    if operator=="range":
                        sql += " %s ( %s >= %s and %s<=%s) "%(fs,name,value[0],name,value[1])
                        fs = "and"
                    elif operator=="bool":
                        if value == "t":
                            sql+= " %s %s='t' "%(fs,name)
                            fs = "and"
                    else:
                        sql+= " %s %s %s %s"%(fs,name,operator,value)
                        fs = "and"
            portalsql=""
            orr=False
            for p in self.portals:
                psql = p.getfind()
                if psql:
                    portalsql += "%s %s "%(fs,psql)
                    if p.name in self.portalconditions:
                        fs = self.portalconditions[str(p.name)]
                        if fs=="or":orr=True
                    else:
                        fs = "and"
            portalsql = portalsql.lstrip()
            if orr:
                if "where" in portalsql[:6]:
                    sql+= "%s ( %s )"%(portalsql[:6],portalsql[6:])
                else:
                    sql+= "%s ( %s )"%(portalsql[:3],portalsql[3:])
            else:
                sql+= portalsql
            sql+=" %s"%self.sortsql
            cursor = self.db.cursor()
            self.FreezeInteractions()
            print "SQL"
            print sql
            cursor.wxexecute(sql,self,self.db.getdata())
 
            
    def OnNavPrint(self,event):
        margins = (wx.Point(15,15),wx.Point(15,15))
        self.printData = wx.PrintData()
        self.printData.SetPaperId(wx.PAPER_A4)
        self.printData.SetPrintMode(wx.PRINT_MODE_PRINTER)
        data = wx.PrintDialogData(self.printData)
        printout = helpers.RecordPrintout(self.fielddata,self.portals,self.data,_("A record"),margins,self)
        p = wx.Printer(data)
        if not p.Print(self,printout,True) and p.GetLastError()==wx.PRINTER_ERROR:
            wx.MessageBox(_("There was a problem printing this record"),_("Print error"),style=wx.OK)
        printout.Destroy()
        
    def FindError(self,win):
        win.Close()
        w = wx.MessageBox(_("An error occured, maybe you cancelled ?"),_("error"),style=wx.OK)
    def buildbuttons(self):
        self.navbar = helpers.navigationbar(self,self.disabled)
        
    def chk_tab(self,event):
        if event.GetKeyCode()==9:
            i=0
            for c in self.tabcontrols:
                if event.GetEventObject()==c:
                    if event.ShiftDown():
                        if i>0:
                            t = self.tabcontrols[i-1]
                        else:
                            t =self.tabcontrols[len(self.tabcontrols)-1]                    
                    else:
                        if i<(len(self.tabcontrols)-1):
                            t = self.tabcontrols[i+1]
                        else:
                            t = self.tabcontrols[0]
                    t.SetFocus()
                    if str(type(t)) in ("<class 'ui.helpers.freetextctrl'>"):
                        t.SetSelection(t.GetLastPosition(),t.GetLastPosition())
                        t.SetInsertionPointEnd()
                i+=1
        else:
            self.afield = event.GetEventObject()
            event.Skip()
    def OnNavOpen(self,event):
        # open other db
        adrun()
        

class keymanager:
    def __init__(self,app):
        self.app = app
        self.base = None
    def char(self,event):
        k = event.GetKeyCode()
        object = event.GetEventObject()
        if (event.ControlDown() and wx.Platform != "__WXMAC__") or (wx.Platform == "__WXMAC__" and event.CmdDown()):
            if k == 14:
                self.base.OnNavNew(None)
            elif k==19:
                self.base.OnNavSort(None)
            elif k==6:
                self.base.OnNavIfind(None)
            elif k==15:
                self.base.OnNavOmmit(None)
            elif k==4:
                self.base.OnNavDelete(None)
            elif k==16:
                self.base.OnNavPrint(None)
            elif k==313:
                self.base.OnNavFirst(None)
            elif k==312:
                self.base.OnNavLast(None)
            elif k==367:
                self.base.OnNavNext(None)
            elif k==366:
                self.base.OnNavPrev(None)
            elif k==17 and wx.Platform!="__WXMAC__":
                while len(browsers)>0:
                    browsers[0].Close()
                event.Skip()
            else:
                event.Skip()
        else:
            event.Skip()
browsers = []

        
def adrun():
    param = helpers.ConnectionWindow()
    status = param.status
    if status:params = param.params
    param.dialog.Destroy()
    if status:
        mdb,info = db.wxconnect(user=params["username"],password=params["password"],host=params["server"],database=params["database"])  
        if info=="ok":
            r = recordbrowser(None,params["table"],mdb)
            if wx.Platform!="__WXMAC__":browsers.append(r)
        else:
            w = wx.MessageBox(_(str(info)),_("error"),style=wx.OK)

def run():
    global app,keym
    app = wx.PySimpleApp(0)
    helpers.setuplang()
    app.SetAppName("wxpypg")
    keym = keymanager(app)
    app.Bind(wx.EVT_CHAR,keym.char)
    param = helpers.ConnectionWindow()
    status = param.status
    if status:params = param.params
    param.dialog.Destroy()
    if status:
        mdb,info = db.wxconnect(user=params["username"],password=params["password"],host=params["server"],database=params["database"],port=params["port"])  
        if info=="ok":
            r = recordbrowser(None,params["table"],mdb)
            if wx.Platform!="__WXMAC__":browsers.append(r)
            app.MainLoop()
        else:
            if info<>None:
                w = wx.MessageBox(_(str(info)),_("error"),style=wx.OK)
    else:
        app.Exit()
if __name__=="__main__":
    run()
