""" wxpypg, A universal record browser for mac,linux and windows

    LICENSE
    =======

    Copyright (c) 2008, Bram Van Steenlandt
    All rights reserved.

    Redistribution and use in source and binary forms, with or without 
    modification, are permitted provided that the following conditions are met:

        * Redistributions of source code must retain the above copyright 
          notice, this list of conditions and the following disclaimer.
        * Redistributions in binary form must reproduce the above copyright 
          notice, this list of conditions and the following disclaimer in the 
          documentation and/or other materials provided with the distribution.
        * Neither the name of the <ORGANIZATION> nor the names of its 
          contributors may be used to endorse or promote products derived from 
          this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
    POSSIBILITY OF SUCH DAMAGE.

    NOTES
    =======
    This is alpha software.  Don't use it on valuable data.
    Parts of this software are based on Randall Smith his pure python postgresql software

"""
import wx
import threading
from pgdb2 import *
from wx import xrc
import _mypg as _pg
import pgcancel
import os
import sys
from wx import animate
_ = wx.GetTranslation
class conbusy(wx.Dialog):
    def __init__(self):
        wx.Dialog.__init__(self,None,wx.NewId(),_("Connecting..."))
        self.sizer = wx.BoxSizer(wx.HORIZONTAL)
	path =os.getcwd()
	uri = path + str(os.sep) + "art" + str(os.sep) + "ani.gif"
        self.ani = animate.GIFAnimationCtrl(self,wx.NewId(),uri)
	self.ani.Play()


        self.sizer.Add(self.ani)


        self.quitbut = wx.Button(self,wx.NewId(),_("Quit now"))
        self.sizer.Add(self.quitbut)

	self.SetSizerAndFit(self.sizer)
	self.stopped=False
class WaitWindow(wx.Frame):
    def __init__(self,parent,dbdata):
	wx.Frame.__init__(self,parent,wx.ID_ANY,_("Please wait"),size=(150,30),style=wx.FRAME_FLOAT_ON_PARENT)
	self.hsizer = wx.BoxSizer(wx.HORIZONTAL)
	self.vsizer = wx.BoxSizer(wx.VERTICAL)
	path =os.getcwd()
        uri = path + str(os.sep) + "art" + str(os.sep) + "wait.png"
	img = wx.Image(uri)
	bm = wx.BitmapFromImage(img)
	self.bm = wx.StaticBitmap(self,wx.NewId(),bm)
	self.hsizer.Add(self.bm)
	self.hsizer.Add(self.vsizer)
	self.SetBackgroundColour("#869ab5")
	self.stat = wx.StaticText(self,wx.NewId(),_("Please wait... query in progress."))
	self.vsizer.Add(self.stat)
	self.cancelbut = wx.Button(self,wx.NewId(),_("Cancel"))
	self.cancelbut.SetBackgroundColour("#FFFFFF")
	self.cancelbut.Bind(wx.EVT_BUTTON,self.cancel)
	self.vsizer.Add(self.cancelbut,flag=wx.ALIGN_RIGHT)
	self.SetSizerAndFit(self.hsizer)
	self.dbdata = dbdata
    def cancel(self,event):
	cc = pgcancel.CancelConnection(self.dbdata["host"],self.dbdata["port"],self.dbdata["dbname"],self.dbdata["user"],self.dbdata["passwd"],self.dbdata["pid"],self.dbdata["secret"])

def wxcancelconnect(dsn = None, user = None, password = None, host = None, database = None, pid=None,secret=None):
    # first get params from DSN
    dbport = -1
    dbhost = ""
    dbbase = ""
    dbuser = ""
    dbpasswd = ""
    dbopt = ""
    dbtty = ""
    try:
        params = string.split(dsn, ":")
        dbhost = params[0]
        dbbase = params[1]
        dbuser = params[2]
        dbpasswd = params[3]
        dbopt = params[4]
        dbtty = params[5]
    except:
        pass

    # override if necessary
    if user != None:
        dbuser = user
    if password != None:
        dbpasswd = password
    if database != None:
        dbbase = database
    if host != None:
        try:
            params = string.split(host, ":")
            dbhost = params[0]
            dbport = int(params[1])
        except:
            pass

    # empty host is localhost
    if dbhost == "":
        dbhost = None
    if dbuser == "":
        dbuser = None

    # open the connection
    pgcancel.CancelConnection( dbhost, dbport,dbname, dbuser, dbpasswd,pid,secret)
class connectingthread(threading.Thread):
    def __init__(self,dbbase, dbhost, dbport, dbopt,dbtty, dbuser, dbpasswd):
	threading.Thread.__init__(self)
	self.dbbase = dbbase
	self.dbhost = dbhost
	self.dbport = dbport
	self.dbopt = dbopt
	self.dbtty = dbtty
	self.dbuser = dbuser
	self.dbpasswd = dbpasswd
    def run(self):
	self.cnx = _pg.connect(self.dbbase, self.dbhost, self.dbport, self.dbopt,self.dbtty, self.dbuser, self.dbpasswd)

def shutdownnow(event):
    print "Abort connection, Closing window, program should terminate within 25 seconds if this was the last window"
    if 1==3:event = wx.Event()
    w = event.GetEventObject().GetParent()
    w.Close()
    w.stopped = True
    # The idea is to close the window, let the program continue but prevent messages
    # The program will then hopefully die when needed silently, if not there will be some zombie
    # Should be done better but how ??


    
    
def wxconnect(dsn = None, user = None, password = None, host = None, database = None,port=None):
    # first get params from DSN
    # additional, we will show a smal window indicating the program is connecting
    # the user has the option to cancel the connection, the program will then quit
    cframe = conbusy()
    quitbut = cframe.quitbut
    quitbut.Bind(wx.EVT_BUTTON,shutdownnow)
    cframe.Show()
    cframe.CenterOnScreen()
    dbport = -1
    dbhost = ""
    dbbase = ""
    dbuser = ""
    dbpasswd = ""
    dbopt = ""
    dbtty = ""
    try:
        params = string.split(dsn, ":")
        dbhost = params[0]
        dbbase = params[1]
        dbuser = params[2]
        dbpasswd = params[3]
        dbopt = params[4]
        dbtty = params[5]
    except:
        pass

    # override if necessary
    if user != None:
        dbuser = user
    if password != None:
        dbpasswd = password
    if database != None:
        dbbase = database
    if port != None:
	dbport=port
    if host != None:
        try:
            params = string.split(host, ":")
            dbhost = params[0]
            dbport = int(params[1])
        except:
            pass

    # empty host is localhost
    if dbhost == "":
        dbhost = None
    if dbuser == "":
        dbuser = None

    # open the connection
    #cnx = _pg.connect(dbbase, dbhost, dbport, dbopt,
    #    dbtty, dbuser, dbpasswd)
    th = connectingthread(dbbase, dbhost, dbport, dbopt,dbtty, dbuser, dbpasswd)
    th.start()
    while th.isAlive():
	time.sleep(0.1)
	wx.YieldIfNeeded()
    if th.cnx.error==False:
	cframe.Close()
	cframe.Destroy()
	return wxpgdbCnx(th.cnx),"ok"
    else:
	cframe.Close()
	cframe.Destroy()
	if cframe.stopped==False:
	    return None,th.cnx.error
	else:
	    return None,None

class executethread(threading.Thread):
    def __init__(self,pgdbcursor,operation,params,parentwindow,waitwindow):
        threading.Thread.__init__(self)
        self.go=True
	self.parentwindow=parentwindow
	self.operation = operation
	self.params=params
	self.pgdbcursor = pgdbcursor
	self.waitwindow = waitwindow
    def run(self):
	try:
	    pgdbCursor.execute(self.pgdbcursor,self.operation,self.params)
	    wx.CallAfter(self.parentwindow.LoadFromCursor,self.pgdbcursor,self.waitwindow)
	except:
	    print "Some work here wich still needs to be done"
	    wx.CallAfter(self.parentwindow.FindError,self.waitwindow)
    def __del__(self):
	self.waitwindow.Destroy()

	
	
        
class wxpgdbCnx(pgdbCnx):
    def __init__(self,cnx):
        self.__cnx = cnx
        self.__cache = pgdbTypeCache(cnx)
	self.startsql=None
        try:
            src = self.__cnx.source()
            src.execute("BEGIN")
        except:
            raise OperationalError, "invalid connection."
    def cursor(self):
        #try:
        src = self.__cnx.source()
	p =  wxpgdbCursor(src, self.__cache)
	if self.startsql<>None:
	    p.execute(self.startsql)
	    self.commit()
	    print "Startsql resent:%s"%self.startsql
	return p
        #except:
        #    raise pgOperationalError, "invalid connection."
    def getkeydata(self):
        src=self.__cnx
        return src.pid,src.secret
    def getdata(self):
	src = self.__cnx
	return src.dbdata
    def rollback(self):
        src = self.__cnx.source()
        src.execute("ROLLBACK")
    def commit(self):
        #try:
        src = self.__cnx.source()
        src.execute("COMMIT")
        src.execute("BEGIN")
        #except:
        #    raise OperationalError, "can't commit."
class wxpgdbCursor(pgdbCursor):
    def wxexecute(self, operation,parentwindow,dbdata, params = None):
	ww = WaitWindow(parentwindow,dbdata)
	
	self.w = executethread(self,operation,params,parentwindow,ww)
	self.w.start()
	wx.FutureCall(100,self.showww,parentwindow,ww)
	
    def showww(self,parent,ww):
	if self.w.isAlive():
	    ww.Show()
	    ww.CenterOnParent()
	
if __name__=="__main__":
    app = wx.PySimpleApp()
    w = conbusy()
    w.ShowModal()
    app.MainLoop()