# CANCEL PARTS
""" wxpypg, A universal record browser for mac,linux and windows

    LICENSE
    =======

    Copyright (c) 2008, Bram Van Steenlandt
    All rights reserved.

    Redistribution and use in source and binary forms, with or without 
    modification, are permitted provided that the following conditions are met:

        * Redistributions of source code must retain the above copyright 
          notice, this list of conditions and the following disclaimer.
        * Redistributions in binary form must reproduce the above copyright 
          notice, this list of conditions and the following disclaimer in the 
          documentation and/or other materials provided with the distribution.
        * Neither the name of the <ORGANIZATION> nor the names of its 
          contributors may be used to endorse or promote products derived from 
          this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
    POSSIBILITY OF SUCH DAMAGE.

    NOTES
    =======
    This is alpha software.  Don't use it on valuable data.
    Parts of this software are based on Randall Smith his pure python postgresql software

"""
from _mypg import *
import os
import socket
import pgmessages
from PGSocket import PGSocket
class CancelConnection(Connection):
    def __init__(self, host, port, dbname, user, passwd,pid,secret):
        # If we are missing a username, try to get it.
        if user is None:
            try:
                user = os.getlogin()
            except:
                raise Exception, 'user is required.'
        if dbname is None:
            dbname = user
        self.host = host
        self.port = port
        self.dbname = dbname
        self.user = user
        self.passwd = passwd
        self.params = {}
        self.connect(pid,secret)
    def connect(self,pid,secret):
        # If host is provided and Unix sockets available, do so.
        if self.host is not None:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.connect((self.host, self.port))
        elif self.host is None and socket.AF_UNIX:
            try:
                sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
                sock.connect('/var/run/postgresql/.s.PGSQL.5432')
            except:
                self.host = 'localhost'
                sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        else: 
            self.host = 'localhost'
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.connect((self.host, self.port))
        # Set timeout so we don't hang forever if something goes wrong.
        sock.settimeout(25)
        self._sock = sock
        
        startup_message = pgmessages.CancelRequest(pid,secret)
        
        sock.send(startup_message.server_message)
        sock.close()