import wx
import sys
"""Socket wrapper for Postgresql connection

    LICENSE
    =======

    Copyright (c) 2004, Randall Smith
    All rights reserved.

    Redistribution and use in source and binary forms, with or without 
    modification, are permitted provided that the following conditions are met:

        * Redistributions of source code must retain the above copyright 
          notice, this list of conditions and the following disclaimer.
        * Redistributions in binary form must reproduce the above copyright 
          notice, this list of conditions and the following disclaimer in the 
          documentation and/or other materials provided with the distribution.
        * Neither the name of the <ORGANIZATION> nor the names of its 
          contributors may be used to endorse or promote products derived from 
          this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
    POSSIBILITY OF SUCH DAMAGE.

"""

import pgmessages

class PGSocket(object):
    def __init__(self, sock):
        self.sock = sock


    def send(self, msg):
        sock = self.sock
        # maybe a sendall would also do
        sent = 0
        while sent<len(msg):
            t = sock.send(msg[sent:])
            sent += t
        return len(msg)

    def receive(self):
        sock = self.sock
        # Get the identifier.
        try:
            identifier = sock.recv(1)
        except:
            # Socket died on us
            print "Socket died 1"
            #wx.MessageBox("A network error occured","error",style = wx.OK)
            return False
            #wx.Exit()
        if len(identifier)==0:
            print "Socket died 2"
            #wx.MessageBox("A network error occured","error",style = wx.OK)
            return False
          
        msg1 = ''
        # Get the message length.
        while len(msg1) < 4:
            #print "Another while loop", str(identifier),len(str(identifier))
            try:
                msg1 += sock.recv(4 - len(msg1))
            except:
                # Socket died on us
                print "Socket died 3"
                #wx.MessageBox("A network error occured","error",style = wx.OK)
                return False
                #wx.Exit()
        length = pgmessages.Int32U(msg1)
        # Get the rest of the message.
        msg2 = ''
        newlength = length - 4
        while len(msg2) < newlength:
            #print "Yet another while loop"
            try:
                msg2 += sock.recv(newlength - len(msg2))
            except:
                # Socket died on us
                print "Socket died 4"
                #wx.MessageBox("A network error occured","error",style = wx.OK)
                return False
                #wx.Exit()
        return identifier + msg1 + msg2

    def getMessage(self):
        raw_message = self.receive()
        #print raw_message
        if raw_message==False:return False
        self.raw_message = raw_message
        return pgmessages.createServerMessage(raw_message)
